/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.index.IndexBuildDriverFactoryProvider;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.operator.index.IndexSnapshotBuilder;
import com.facebook.presto.operator.index.IndexSplit;
import com.facebook.presto.operator.index.IndexedData;
import com.facebook.presto.operator.index.PageBuffer;
import com.facebook.presto.operator.index.PageRecordSet;
import com.facebook.presto.operator.index.StreamingIndexedData;
import com.facebook.presto.operator.index.UpdateRequest;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class IndexLoader {
    private static final ConnectorId INDEX_CONNECTOR_ID = new ConnectorId("$index");
    private final BlockingQueue<UpdateRequest> updateRequests = new LinkedBlockingQueue<UpdateRequest>();
    private final List<Type> outputTypes;
    private final IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider;
    private final int expectedPositions;
    private final DataSize maxIndexMemorySize;
    private final IndexJoinLookupStats stats;
    private final AtomicReference<TaskContext> taskContextReference = new AtomicReference();
    private final Set<Integer> lookupSourceInputChannels;
    private final List<Integer> keyOutputChannels;
    private final OptionalInt keyOutputHashChannel;
    private final List<Type> keyTypes;
    private final PagesIndex.Factory pagesIndexFactory;
    private final JoinCompiler joinCompiler;
    private final Duration indexLoaderTimeout;
    @GuardedBy(value="this")
    private IndexSnapshotLoader indexSnapshotLoader;
    @GuardedBy(value="this")
    private PipelineContext pipelineContext;
    @GuardedBy(value="this")
    private final AtomicReference<IndexSnapshot> indexSnapshotReference;

    public IndexLoader(Set<Integer> lookupSourceInputChannels, List<Integer> keyOutputChannels, OptionalInt keyOutputHashChannel, List<Type> outputTypes, IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider, int expectedPositions, DataSize maxIndexMemorySize, IndexJoinLookupStats stats, PagesIndex.Factory pagesIndexFactory, JoinCompiler joinCompiler, Duration indexLoaderTimeout) {
        Objects.requireNonNull(lookupSourceInputChannels, "lookupSourceInputChannels is null");
        Preconditions.checkArgument((!lookupSourceInputChannels.isEmpty() ? 1 : 0) != 0, (Object)"lookupSourceInputChannels must not be empty");
        Objects.requireNonNull(keyOutputChannels, "keyOutputChannels is null");
        Preconditions.checkArgument((!keyOutputChannels.isEmpty() ? 1 : 0) != 0, (Object)"keyOutputChannels must not be empty");
        Objects.requireNonNull(keyOutputHashChannel, "keyOutputHashChannel is null");
        Preconditions.checkArgument((lookupSourceInputChannels.size() <= keyOutputChannels.size() ? 1 : 0) != 0, (Object)"Lookup channels must supply a subset of the actual index columns");
        Objects.requireNonNull(outputTypes, "outputTypes is null");
        Objects.requireNonNull(indexBuildDriverFactoryProvider, "indexBuildDriverFactoryProvider is null");
        Objects.requireNonNull(maxIndexMemorySize, "maxIndexMemorySize is null");
        Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        Objects.requireNonNull(indexLoaderTimeout, "indexLoaderTimeout is null");
        this.lookupSourceInputChannels = ImmutableSet.copyOf(lookupSourceInputChannels);
        this.keyOutputChannels = ImmutableList.copyOf(keyOutputChannels);
        this.keyOutputHashChannel = keyOutputHashChannel;
        this.outputTypes = ImmutableList.copyOf(outputTypes);
        this.indexBuildDriverFactoryProvider = indexBuildDriverFactoryProvider;
        this.expectedPositions = expectedPositions;
        this.maxIndexMemorySize = maxIndexMemorySize;
        this.stats = stats;
        this.pagesIndexFactory = pagesIndexFactory;
        this.joinCompiler = joinCompiler;
        this.indexLoaderTimeout = indexLoaderTimeout;
        ImmutableList.Builder keyTypeBuilder = ImmutableList.builder();
        for (int keyOutputChannel : keyOutputChannels) {
            keyTypeBuilder.add((Object)outputTypes.get(keyOutputChannel));
        }
        this.keyTypes = keyTypeBuilder.build();
        this.indexSnapshotReference = new AtomicReference<IndexSnapshot>(new IndexSnapshot(new EmptyLookupSource(outputTypes.size()), new EmptyLookupSource(keyOutputChannels.size())));
    }

    public void setContext(TaskContext taskContext) {
        this.taskContextReference.compareAndSet(null, taskContext);
    }

    public int getChannelCount() {
        return this.outputTypes.size();
    }

    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    public IndexSnapshot getIndexSnapshot() {
        return this.indexSnapshotReference.get();
    }

    public IndexedData getIndexedDataForKeys(int position, Page indexPage) {
        int totalPositions = indexPage.getPositionCount();
        int remainingPositions = totalPositions - position;
        return this.getIndexedDataForKeys(indexPage.getRegion(position, remainingPositions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexedData getIndexedDataForKeys(Page indexPage) {
        UpdateRequest myUpdateRequest = new UpdateRequest(indexPage);
        this.updateRequests.add(myUpdateRequest);
        IndexLoader indexLoader = this;
        synchronized (indexLoader) {
            if (!myUpdateRequest.isFinished()) {
                this.stats.recordIndexJoinLookup();
                this.initializeStateIfNecessary();
                ArrayList<UpdateRequest> requests = new ArrayList<UpdateRequest>();
                this.updateRequests.drainTo(requests);
                try {
                    long initialCacheSizeInBytes = this.indexSnapshotLoader.getCacheSizeInBytes();
                    if (this.indexSnapshotLoader.load(requests)) {
                        return myUpdateRequest.getFinishedIndexSnapshot();
                    }
                    if (initialCacheSizeInBytes > 0L && this.indexSnapshotLoader.load(requests)) {
                        this.stats.recordSuccessfulIndexJoinLookupByCacheReset();
                        return myUpdateRequest.getFinishedIndexSnapshot();
                    }
                }
                catch (Throwable t) {
                    for (UpdateRequest request : requests) {
                        request.failed(t);
                    }
                    throw t;
                }
                if (requests.size() > 1) {
                    Iterables.addAll(this.updateRequests, (Iterable)Iterables.filter(requests, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)myUpdateRequest))));
                    if (this.indexSnapshotLoader.load((List<UpdateRequest>)ImmutableList.of((Object)myUpdateRequest))) {
                        this.stats.recordSuccessfulIndexJoinLookupBySingleRequest();
                        return myUpdateRequest.getFinishedIndexSnapshot();
                    }
                }
                int totalPositions = indexPage.getPositionCount();
                for (int attemptedPositions = totalPositions / 10; attemptedPositions > 1; attemptedPositions /= 10) {
                    myUpdateRequest = new UpdateRequest(indexPage.getRegion(0, attemptedPositions));
                    if (!this.indexSnapshotLoader.load((List<UpdateRequest>)ImmutableList.of((Object)myUpdateRequest))) continue;
                    this.stats.recordSuccessfulIndexJoinLookupByLimitedRequest();
                    return myUpdateRequest.getFinishedIndexSnapshot();
                }
                this.stats.recordStreamedIndexJoinLookup();
                return this.streamIndexDataForSingleKey(myUpdateRequest);
            }
        }
        return myUpdateRequest.getFinishedIndexSnapshot();
    }

    public IndexedData streamIndexDataForSingleKey(UpdateRequest updateRequest) {
        Page indexKeyTuple = updateRequest.getPage().getRegion(0, 1);
        PageBuffer pageBuffer = new PageBuffer(100);
        DriverFactory driverFactory = this.indexBuildDriverFactoryProvider.createStreaming(pageBuffer, indexKeyTuple);
        Driver driver = driverFactory.createDriver(this.pipelineContext.addDriverContext());
        PageRecordSet pageRecordSet = new PageRecordSet(this.keyTypes, indexKeyTuple);
        PlanNodeId planNodeId = driverFactory.getSourceId().get();
        ScheduledSplit split = new ScheduledSplit(0L, planNodeId, new Split(INDEX_CONNECTOR_ID, new ConnectorTransactionHandle(){}, new IndexSplit(pageRecordSet)));
        driver.updateSource(new TaskSource(planNodeId, (Set<ScheduledSplit>)ImmutableSet.of((Object)split), true));
        return new StreamingIndexedData(this.outputTypes, this.keyTypes, indexKeyTuple, pageBuffer, driver);
    }

    private synchronized void initializeStateIfNecessary() {
        if (this.pipelineContext == null) {
            TaskContext taskContext = this.taskContextReference.get();
            Preconditions.checkState((taskContext != null ? 1 : 0) != 0, (Object)"Task context must be set before index can be built");
            this.pipelineContext = taskContext.addPipelineContext(this.indexBuildDriverFactoryProvider.getPipelineId(), true, true, false);
        }
        if (this.indexSnapshotLoader == null) {
            this.indexSnapshotLoader = new IndexSnapshotLoader(this.indexBuildDriverFactoryProvider, this.pipelineContext, this.indexSnapshotReference, this.lookupSourceInputChannels, this.keyTypes, this.keyOutputChannels, this.keyOutputHashChannel, this.expectedPositions, this.maxIndexMemorySize, this.pagesIndexFactory, this.joinCompiler, this.indexLoaderTimeout);
        }
    }

    static /* synthetic */ ConnectorId access$100() {
        return INDEX_CONNECTOR_ID;
    }

    private static class EmptyLookupSource
    implements LookupSource {
        private final int channelCount;

        public EmptyLookupSource(int channelCount) {
            this.channelCount = channelCount;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int getChannelCount() {
            return this.channelCount;
        }

        @Override
        public long getJoinPositionCount() {
            return 0L;
        }

        @Override
        public long getInMemorySizeInBytes() {
            return 0L;
        }

        @Override
        public long joinPositionWithinPartition(long joinPosition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getJoinPosition(int position, Page page, Page allChannelsPage, long rawHash) {
            return -2L;
        }

        @Override
        public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
            return -2L;
        }

        @Override
        public long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
            return -2L;
        }

        @Override
        public boolean isJoinPositionEligible(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
            return true;
        }

        @Override
        public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }

    @NotThreadSafe
    private static class IndexSnapshotLoader {
        private final DriverFactory driverFactory;
        private final PipelineContext pipelineContext;
        private final Set<Integer> lookupSourceInputChannels;
        private final Set<Integer> allInputChannels;
        private final List<Type> outputTypes;
        private final List<Type> indexTypes;
        private final AtomicReference<IndexSnapshot> indexSnapshotReference;
        private final JoinCompiler joinCompiler;
        private final IndexSnapshotBuilder indexSnapshotBuilder;
        private final Duration timeout;

        private IndexSnapshotLoader(IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider, PipelineContext pipelineContext, AtomicReference<IndexSnapshot> indexSnapshotReference, Set<Integer> lookupSourceInputChannels, List<Type> indexTypes, List<Integer> keyOutputChannels, OptionalInt keyOutputHashChannel, int expectedPositions, DataSize maxIndexMemorySize, PagesIndex.Factory pagesIndexFactory, JoinCompiler joinCompiler, Duration timeout) {
            this.pipelineContext = pipelineContext;
            this.indexSnapshotReference = indexSnapshotReference;
            this.lookupSourceInputChannels = lookupSourceInputChannels;
            this.outputTypes = indexBuildDriverFactoryProvider.getOutputTypes();
            this.indexTypes = indexTypes;
            this.joinCompiler = joinCompiler;
            this.timeout = timeout;
            this.indexSnapshotBuilder = new IndexSnapshotBuilder(this.outputTypes, keyOutputChannels, keyOutputHashChannel, pipelineContext.addDriverContext(), maxIndexMemorySize, expectedPositions, pagesIndexFactory);
            this.driverFactory = indexBuildDriverFactoryProvider.createSnapshot(pipelineContext.getPipelineId(), this.indexSnapshotBuilder);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < indexTypes.size(); ++i) {
                builder.add((Object)i);
            }
            this.allInputChannels = builder.build();
        }

        public long getCacheSizeInBytes() {
            return this.indexSnapshotBuilder.getMemoryInBytes();
        }

        /*
         * Exception decompiling
         */
        public boolean load(List<UpdateRequest> requests) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void clearCachedData() {
            this.indexSnapshotReference.set(new IndexSnapshot(new EmptyLookupSource(this.outputTypes.size()), new EmptyLookupSource(this.indexTypes.size())));
            this.indexSnapshotBuilder.reset();
        }
    }
}

