/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.array.AdaptiveLongBigArray;
import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PagesIndexComparator;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SimplePagesIndexComparator
implements PagesIndexComparator {
    private final int[] sortChannels;
    private final SortOrder[] sortOrders;
    private final Type[] sortTypes;

    public SimplePagesIndexComparator(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        this.sortChannels = Ints.toArray((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
        this.sortOrders = Objects.requireNonNull(sortOrders, "sortOrders is null").toArray(new SortOrder[0]);
        this.sortTypes = Objects.requireNonNull(sortTypes, "sortTypes is null").toArray(new Type[0]);
    }

    @Override
    public int compareTo(PagesIndex pagesIndex, int leftPosition, int rightPosition) {
        AdaptiveLongBigArray valueAddresses = pagesIndex.getValueAddresses();
        long leftPageAddress = valueAddresses.get(leftPosition);
        long rightPageAddress = valueAddresses.get(rightPosition);
        int leftBlockIndex = SyntheticAddress.decodeSliceIndex(leftPageAddress);
        int leftBlockPosition = SyntheticAddress.decodePosition(leftPageAddress);
        int rightBlockIndex = SyntheticAddress.decodeSliceIndex(rightPageAddress);
        int rightBlockPosition = SyntheticAddress.decodePosition(rightPageAddress);
        for (int i = 0; i < this.sortChannels.length; ++i) {
            int sortChannel = this.sortChannels[i];
            SortOrder sortOrder = this.sortOrders[i];
            Type sortType = this.sortTypes[i];
            ObjectArrayList<Block> indexChannel = pagesIndex.getChannel(sortChannel);
            Block leftBlock = (Block)indexChannel.get(leftBlockIndex);
            Block rightBlock = (Block)indexChannel.get(rightBlockIndex);
            try {
                int compare = sortOrder.compareBlockValue(sortType, leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
                if (compare == 0) continue;
                return compare;
            }
            catch (NotSupportedException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
            }
        }
        return 0;
    }
}

