/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.JoinBridgeManager;
import com.facebook.presto.operator.JoinOperatorFactory;
import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.LookupJoinOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupOuterOperator;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class LookupJoinOperatorFactory
implements JoinOperatorFactory {
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final List<Type> probeTypes;
    private final List<Type> buildOutputTypes;
    private final LookupJoinOperators.JoinType joinType;
    private final JoinProbe.JoinProbeFactory joinProbeFactory;
    private final Optional<JoinOperatorFactory.OuterOperatorFactoryResult> outerOperatorFactoryResult;
    private final JoinBridgeManager<? extends LookupSourceFactory> joinBridgeManager;
    private final OptionalInt totalOperatorsCount;
    private final HashGenerator probeHashGenerator;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private boolean closed;

    public LookupJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactoryManager, List<Type> probeTypes, List<Type> probeOutputTypes, List<Type> buildOutputTypes, LookupJoinOperators.JoinType joinType, JoinProbe.JoinProbeFactory joinProbeFactory, OptionalInt totalOperatorsCount, List<Integer> probeJoinChannels, OptionalInt probeHashChannel, PartitioningSpillerFactory partitioningSpillerFactory) {
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.probeTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeTypes, "probeTypes is null"));
        this.buildOutputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null"));
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
        this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
        this.joinBridgeManager = lookupSourceFactoryManager;
        this.joinBridgeManager.incrementProbeFactoryCount();
        this.outerOperatorFactoryResult = joinType == LookupJoinOperators.JoinType.INNER || joinType == LookupJoinOperators.JoinType.PROBE_OUTER ? Optional.empty() : Optional.of(new JoinOperatorFactory.OuterOperatorFactoryResult(new LookupOuterOperator.LookupOuterOperatorFactory(operatorId, planNodeId, probeOutputTypes, buildOutputTypes, lookupSourceFactoryManager), lookupSourceFactoryManager.getBuildExecutionStrategy()));
        this.totalOperatorsCount = Objects.requireNonNull(totalOperatorsCount, "totalOperatorsCount is null");
        Objects.requireNonNull(probeHashChannel, "probeHashChannel is null");
        if (probeHashChannel.isPresent()) {
            this.probeHashGenerator = new PrecomputedHashGenerator(probeHashChannel.getAsInt());
        } else {
            Objects.requireNonNull(probeJoinChannels, "probeJoinChannels is null");
            List hashTypes = (List)probeJoinChannels.stream().map(probeTypes::get).collect(ImmutableList.toImmutableList());
            this.probeHashGenerator = new InterpretedHashGenerator((List<Type>)hashTypes, probeJoinChannels);
        }
        this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
    }

    private LookupJoinOperatorFactory(LookupJoinOperatorFactory other) {
        Objects.requireNonNull(other, "other is null");
        Preconditions.checkArgument((!other.closed ? 1 : 0) != 0, (Object)"cannot duplicated closed OperatorFactory");
        this.operatorId = other.operatorId;
        this.planNodeId = other.planNodeId;
        this.probeTypes = other.probeTypes;
        this.buildOutputTypes = other.buildOutputTypes;
        this.joinType = other.joinType;
        this.joinProbeFactory = other.joinProbeFactory;
        this.joinBridgeManager = other.joinBridgeManager;
        this.outerOperatorFactoryResult = other.outerOperatorFactoryResult;
        this.totalOperatorsCount = other.totalOperatorsCount;
        this.probeHashGenerator = other.probeHashGenerator;
        this.partitioningSpillerFactory = other.partitioningSpillerFactory;
        this.closed = false;
        this.joinBridgeManager.incrementProbeFactoryCount();
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    @Override
    public Operator createOperator(DriverContext driverContext) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
        LookupSourceFactory lookupSourceFactory = this.joinBridgeManager.getJoinBridge(driverContext.getLifespan());
        OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LookupJoinOperator.class.getSimpleName());
        lookupSourceFactory.setTaskContext(driverContext.getPipelineContext().getTaskContext());
        this.joinBridgeManager.probeOperatorCreated(driverContext.getLifespan());
        return new LookupJoinOperator(operatorContext, this.probeTypes, this.buildOutputTypes, this.joinType, lookupSourceFactory, this.joinProbeFactory, () -> this.joinBridgeManager.probeOperatorClosed(driverContext.getLifespan()), this.totalOperatorsCount, this.probeHashGenerator, this.partitioningSpillerFactory);
    }

    @Override
    public void noMoreOperators() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closed = true;
        this.joinBridgeManager.probeOperatorFactoryClosedForAllLifespans();
    }

    @Override
    public void noMoreOperators(Lifespan lifespan) {
        this.joinBridgeManager.probeOperatorFactoryClosed(lifespan);
    }

    @Override
    public OperatorFactory duplicate() {
        return new LookupJoinOperatorFactory(this);
    }

    @Override
    public Optional<JoinOperatorFactory.OuterOperatorFactoryResult> createOuterOperatorFactory() {
        return this.outerOperatorFactoryResult;
    }
}

