/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;

public class FileFragmentResultCacheConfig {
    private boolean cachingEnabled;
    private URI baseDirectory;
    private boolean blockEncodingCompressionEnabled;
    private int maxCachedEntries = 10000;
    private Duration cacheTtl = new Duration(2.0, TimeUnit.DAYS);
    private DataSize maxInFlightSize = new DataSize(1.0, DataSize.Unit.GIGABYTE);
    private DataSize maxSinglePagesSize = new DataSize(500.0, DataSize.Unit.MEGABYTE);

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    @Config(value="fragment-result-cache.enabled")
    @ConfigDescription(value="Enable fragment result caching")
    public FileFragmentResultCacheConfig setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
        return this;
    }

    public URI getBaseDirectory() {
        return this.baseDirectory;
    }

    @Config(value="fragment-result-cache.base-directory")
    @ConfigDescription(value="Base URI to cache data")
    public FileFragmentResultCacheConfig setBaseDirectory(URI baseDirectory) {
        this.baseDirectory = baseDirectory;
        return this;
    }

    public boolean isBlockEncodingCompressionEnabled() {
        return this.blockEncodingCompressionEnabled;
    }

    @Config(value="fragment-result-cache.block-encoding-compression-enabled")
    @ConfigDescription(value="Enable compression for block encoding")
    public FileFragmentResultCacheConfig setBlockEncodingCompressionEnabled(boolean blockEncodingCompressionEnabled) {
        this.blockEncodingCompressionEnabled = blockEncodingCompressionEnabled;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxCachedEntries() {
        return this.maxCachedEntries;
    }

    @Config(value="fragment-result-cache.max-cached-entries")
    @ConfigDescription(value="Number of entries allowed in cache")
    public FileFragmentResultCacheConfig setMaxCachedEntries(int maxCachedEntries) {
        this.maxCachedEntries = maxCachedEntries;
        return this;
    }

    @MinDuration(value="0s")
    public Duration getCacheTtl() {
        return this.cacheTtl;
    }

    @Config(value="fragment-result-cache.cache-ttl")
    @ConfigDescription(value="Time-to-live for a cache entry")
    public FileFragmentResultCacheConfig setCacheTtl(Duration cacheTtl) {
        this.cacheTtl = cacheTtl;
        return this;
    }

    @MinDataSize(value="0B")
    public DataSize getMaxInFlightSize() {
        return this.maxInFlightSize;
    }

    @Config(value="fragment-result-cache.max-in-flight-size")
    @ConfigDescription(value="Maximum size of pages in memory waiting to be flushed")
    public FileFragmentResultCacheConfig setMaxInFlightSize(DataSize maxInFlightSize) {
        this.maxInFlightSize = maxInFlightSize;
        return this;
    }

    @MinDataSize(value="0B")
    public DataSize getMaxSinglePagesSize() {
        return this.maxSinglePagesSize;
    }

    @Config(value="fragment-result-cache.max-single-pages-size")
    @ConfigDescription(value="Maximum size of pages write to flushed")
    public FileFragmentResultCacheConfig setMaxSinglePagesSize(DataSize maxSinglePagesSize) {
        this.maxSinglePagesSize = maxSinglePagesSize;
        return this;
    }
}

