/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.metadata.SessionFunctionHandle;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;

public final class SessionFunctionUtils {
    private SessionFunctionUtils() {
    }

    public static Collection<? extends SqlFunction> listFunctions(Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions) {
        return sessionFunctions.values();
    }

    public static Collection<String> listFunctionNames(Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions) {
        return (Collection)sessionFunctions.keySet().stream().map(SqlFunctionId::getFunctionName).map(QualifiedObjectName::getObjectName).collect(ImmutableList.toImmutableList());
    }

    public static Collection<SqlFunction> getFunctions(Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, QualifiedObjectName functionName) {
        return (Collection)sessionFunctions.entrySet().stream().filter(e -> ((SqlFunctionId)e.getKey()).getFunctionName().getObjectName().equals(functionName.getObjectName())).map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
    }

    public static FunctionHandle getFunctionHandle(Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, Signature signature) {
        return new SessionFunctionHandle(sessionFunctions.get(new SqlFunctionId(signature.getName(), signature.getArgumentTypes())));
    }
}

