/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecFactory;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.metadata.AnalyzePropertyManager;
import com.facebook.presto.metadata.AnalyzeTableHandle;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.CatalogMetadata;
import com.facebook.presto.metadata.ColumnPropertyManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUpdates;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.NewTableLayout;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.metadata.PartitioningMetadata;
import com.facebook.presto.metadata.ProcedureRegistry;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.ResolvedIndex;
import com.facebook.presto.metadata.SchemaPropertyManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorMaterializedViewDefinition;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorResolvedIndex;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.MaterializedViewStatus;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableLayoutFilterCoverage;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.ConnectorPartitioningMetadata;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.security.GrantInfo;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.statistics.TableStatisticsMetadata;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.TypeDeserializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Provider;

public class MetadataManager
implements Metadata {
    private static final Logger log = Logger.get(MetadataManager.class);
    private final FunctionAndTypeManager functionAndTypeManager;
    private final ProcedureRegistry procedures;
    private final JsonCodec<ViewDefinition> viewCodec;
    private final BlockEncodingSerde blockEncodingSerde;
    private final SessionPropertyManager sessionPropertyManager;
    private final SchemaPropertyManager schemaPropertyManager;
    private final TablePropertyManager tablePropertyManager;
    private final ColumnPropertyManager columnPropertyManager;
    private final AnalyzePropertyManager analyzePropertyManager;
    private final TransactionManager transactionManager;
    private final ConcurrentMap<String, Collection<ConnectorMetadata>> catalogsByQueryId = new ConcurrentHashMap<String, Collection<ConnectorMetadata>>();
    private final Set<QueryId> queriesWithRegisteredCallbacks = ConcurrentHashMap.newKeySet();

    @VisibleForTesting
    public MetadataManager(FunctionAndTypeManager functionAndTypeManager, BlockEncodingSerde blockEncodingSerde, SessionPropertyManager sessionPropertyManager, SchemaPropertyManager schemaPropertyManager, TablePropertyManager tablePropertyManager, ColumnPropertyManager columnPropertyManager, AnalyzePropertyManager analyzePropertyManager, TransactionManager transactionManager) {
        this(MetadataManager.createTestingViewCodec(functionAndTypeManager), blockEncodingSerde, sessionPropertyManager, schemaPropertyManager, tablePropertyManager, columnPropertyManager, analyzePropertyManager, transactionManager, functionAndTypeManager);
    }

    @Inject
    public MetadataManager(JsonCodec<ViewDefinition> viewCodec, BlockEncodingSerde blockEncodingSerde, SessionPropertyManager sessionPropertyManager, SchemaPropertyManager schemaPropertyManager, TablePropertyManager tablePropertyManager, ColumnPropertyManager columnPropertyManager, AnalyzePropertyManager analyzePropertyManager, TransactionManager transactionManager, FunctionAndTypeManager functionAndTypeManager) {
        this.viewCodec = Objects.requireNonNull(viewCodec, "viewCodec is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.schemaPropertyManager = Objects.requireNonNull(schemaPropertyManager, "schemaPropertyManager is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
        this.columnPropertyManager = Objects.requireNonNull(columnPropertyManager, "columnPropertyManager is null");
        this.analyzePropertyManager = Objects.requireNonNull(analyzePropertyManager, "analyzePropertyManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
        this.procedures = new ProcedureRegistry(functionAndTypeManager);
        this.verifyComparableOrderableContract();
    }

    public static MetadataManager createTestMetadataManager() {
        return MetadataManager.createTestMetadataManager(new FeaturesConfig());
    }

    public static MetadataManager createTestMetadataManager(FeaturesConfig featuresConfig) {
        return MetadataManager.createTestMetadataManager(new CatalogManager(), featuresConfig);
    }

    public static MetadataManager createTestMetadataManager(CatalogManager catalogManager) {
        return MetadataManager.createTestMetadataManager(catalogManager, new FeaturesConfig());
    }

    public static MetadataManager createTestMetadataManager(CatalogManager catalogManager, FeaturesConfig featuresConfig) {
        return MetadataManager.createTestMetadataManager(InMemoryTransactionManager.createTestTransactionManager(catalogManager), featuresConfig);
    }

    public static MetadataManager createTestMetadataManager(TransactionManager transactionManager, FeaturesConfig featuresConfig) {
        BlockEncodingManager blockEncodingManager = new BlockEncodingManager();
        return new MetadataManager(new FunctionAndTypeManager(transactionManager, (BlockEncodingSerde)blockEncodingManager, featuresConfig, new HandleResolver(), (Set<Type>)ImmutableSet.of()), (BlockEncodingSerde)blockEncodingManager, new SessionPropertyManager(), new SchemaPropertyManager(), new TablePropertyManager(), new ColumnPropertyManager(), new AnalyzePropertyManager(), transactionManager);
    }

    @Override
    public final void verifyComparableOrderableContract() {
        HashMultimap missingOperators = HashMultimap.create();
        for (Type type : this.functionAndTypeManager.getTypes()) {
            if (type.isComparable()) {
                if (!this.canResolveOperator(OperatorType.HASH_CODE, TypeSignatureProvider.fromTypes(type))) {
                    missingOperators.put((Object)type, (Object)OperatorType.HASH_CODE);
                }
                if (!this.canResolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes(type, type))) {
                    missingOperators.put((Object)type, (Object)OperatorType.EQUAL);
                }
                if (!this.canResolveOperator(OperatorType.NOT_EQUAL, TypeSignatureProvider.fromTypes(type, type))) {
                    missingOperators.put((Object)type, (Object)OperatorType.NOT_EQUAL);
                }
            }
            if (!type.isOrderable()) continue;
            for (OperatorType operator : ImmutableList.of((Object)OperatorType.LESS_THAN, (Object)OperatorType.LESS_THAN_OR_EQUAL, (Object)OperatorType.GREATER_THAN, (Object)OperatorType.GREATER_THAN_OR_EQUAL)) {
                if (this.canResolveOperator(operator, TypeSignatureProvider.fromTypes(type, type))) continue;
                missingOperators.put((Object)type, (Object)operator);
            }
            if (this.canResolveOperator(OperatorType.BETWEEN, TypeSignatureProvider.fromTypes(type, type, type))) continue;
            missingOperators.put((Object)type, (Object)OperatorType.BETWEEN);
        }
        if (!missingOperators.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Type type : missingOperators.keySet()) {
                messages.add(String.format("%s missing for %s", missingOperators.get((Object)type), type));
            }
            throw new IllegalStateException(Joiner.on((String)", ").join(messages));
        }
    }

    @Override
    public Type getType(TypeSignature signature) {
        return this.functionAndTypeManager.getType(signature);
    }

    @Override
    public void registerBuiltInFunctions(List<? extends SqlFunction> functionInfos) {
        this.functionAndTypeManager.registerBuiltInFunctions(functionInfos);
    }

    @Override
    public boolean schemaExists(Session session, CatalogSchemaName schema) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, schema.getCatalogName());
        if (!catalog.isPresent()) {
            return false;
        }
        CatalogMetadata catalogMetadata = catalog.get();
        ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getConnectorId());
        return catalogMetadata.listConnectorIds().stream().map(catalogMetadata::getMetadataFor).anyMatch(metadata -> metadata.schemaExists(connectorSession, schema.getSchemaName()));
    }

    @Override
    public boolean catalogExists(Session session, String catalogName) {
        return this.getOptionalCatalogMetadata(session, catalogName).isPresent();
    }

    @Override
    public List<String> listSchemaNames(Session session, String catalogName) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, catalogName);
        ImmutableSet.Builder schemaNames = ImmutableSet.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getConnectorId());
            for (ConnectorId connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                metadata.listSchemaNames(connectorSession).stream().map(schema -> schema.toLowerCase(Locale.ENGLISH)).forEach(arg_0 -> ((ImmutableSet.Builder)schemaNames).add(arg_0));
            }
        }
        return ImmutableList.copyOf((Collection)schemaNames.build());
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName table) {
        ConnectorId connectorId;
        CatalogMetadata catalogMetadata;
        ConnectorMetadata metadata;
        ConnectorTableHandle tableHandle;
        Objects.requireNonNull(table, "table is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, table.getCatalogName());
        if (catalog.isPresent() && (tableHandle = (metadata = (catalogMetadata = catalog.get()).getMetadataFor(connectorId = catalogMetadata.getConnectorId(session, table))).getTableHandle(session.toConnectorSession(connectorId), MetadataUtil.toSchemaTableName(table))) != null) {
            return Optional.of(new TableHandle(connectorId, tableHandle, catalogMetadata.getTransactionHandleFor(connectorId), Optional.empty()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<TableHandle> getTableHandleForStatisticsCollection(Session session, QualifiedObjectName table, Map<String, Object> analyzeProperties) {
        ConnectorId connectorId;
        CatalogMetadata catalogMetadata;
        ConnectorMetadata metadata;
        ConnectorTableHandle tableHandle;
        Objects.requireNonNull(table, "table is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, table.getCatalogName());
        if (catalog.isPresent() && (tableHandle = (metadata = (catalogMetadata = catalog.get()).getMetadataFor(connectorId = catalogMetadata.getConnectorId(session, table))).getTableHandleForStatisticsCollection(session.toConnectorSession(connectorId), MetadataUtil.toSchemaTableName(table), analyzeProperties)) != null) {
            return Optional.of(new TableHandle(connectorId, tableHandle, catalogMetadata.getTransactionHandleFor(connectorId), Optional.empty()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<SystemTable> getSystemTable(Session session, QualifiedObjectName tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "table is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, tableName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorId connectorId = catalogMetadata.getConnectorId();
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
            return metadata.getSystemTable(session.toConnectorSession(connectorId), MetadataUtil.toSchemaTableName(tableName));
        }
        return Optional.empty();
    }

    @Override
    public TableLayoutResult getLayout(Session session, TableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        Preconditions.checkArgument((!constraint.getSummary().isNone() ? 1 : 0) != 0, (Object)"Cannot get Layout if constraint is none");
        ConnectorId connectorId = table.getConnectorId();
        ConnectorTableHandle connectorTable = table.getConnectorHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        List layouts = metadata.getTableLayouts(connectorSession, connectorTable, constraint, desiredColumns);
        if (layouts.size() != 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Connector returned multiple layouts for table " + table);
        }
        return new TableLayoutResult(TableLayout.fromConnectorLayout(connectorId, table.getConnectorHandle(), table.getTransaction(), ((ConnectorTableLayoutResult)layouts.get(0)).getTableLayout()), (TupleDomain<ColumnHandle>)((ConnectorTableLayoutResult)layouts.get(0)).getUnenforcedConstraint());
    }

    @Override
    public TableLayout getLayout(Session session, TableHandle handle) {
        ConnectorId connectorId = handle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
        return TableLayout.fromConnectorLayout(connectorId, handle.getConnectorHandle(), handle.getTransaction(), metadata.getTableLayout(session.toConnectorSession(connectorId), this.resolveTableLayout(session, handle)));
    }

    @Override
    public TableHandle getAlternativeTableHandle(Session session, TableHandle tableHandle, PartitioningHandle partitioningHandle) {
        Preconditions.checkArgument((boolean)partitioningHandle.getConnectorId().isPresent(), (Object)"Expect partitioning handle from connector, got system partitioning handle");
        ConnectorId connectorId = partitioningHandle.getConnectorId().get();
        Preconditions.checkArgument((boolean)connectorId.equals((Object)tableHandle.getConnectorId()), (Object)"ConnectorId of tableLayoutHandle and partitioningHandle does not match");
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
        ConnectorTableLayoutHandle newTableLayoutHandle = metadata.getAlternativeLayoutHandle(session.toConnectorSession(connectorId), (ConnectorTableLayoutHandle)tableHandle.getLayout().get(), partitioningHandle.getConnectorHandle());
        return new TableHandle(tableHandle.getConnectorId(), tableHandle.getConnectorHandle(), tableHandle.getTransaction(), Optional.of(newTableLayoutHandle));
    }

    @Override
    public boolean isLegacyGetLayoutSupported(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
        return metadata.isLegacyGetLayoutSupported(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
    }

    @Override
    public Optional<PartitioningHandle> getCommonPartitioning(Session session, PartitioningHandle left, PartitioningHandle right) {
        Optional<ConnectorId> leftConnectorId = left.getConnectorId();
        Optional<ConnectorId> rightConnectorId = right.getConnectorId();
        if (!(leftConnectorId.isPresent() && rightConnectorId.isPresent() && leftConnectorId.equals(rightConnectorId))) {
            return Optional.empty();
        }
        if (!left.getTransactionHandle().equals(right.getTransactionHandle())) {
            return Optional.empty();
        }
        ConnectorId connectorId = leftConnectorId.get();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
        Optional commonHandle = metadata.getCommonPartitioningHandle(session.toConnectorSession(connectorId), left.getConnectorHandle(), right.getConnectorHandle());
        return commonHandle.map(handle -> new PartitioningHandle(Optional.of(connectorId), left.getTransactionHandle(), (ConnectorPartitioningHandle)handle));
    }

    @Override
    public boolean isRefinedPartitioningOver(Session session, PartitioningHandle left, PartitioningHandle right) {
        Optional<ConnectorId> leftConnectorId = left.getConnectorId();
        Optional<ConnectorId> rightConnectorId = right.getConnectorId();
        if (!(leftConnectorId.isPresent() && rightConnectorId.isPresent() && leftConnectorId.equals(rightConnectorId))) {
            return false;
        }
        if (!left.getTransactionHandle().equals(right.getTransactionHandle())) {
            return false;
        }
        ConnectorId connectorId = leftConnectorId.get();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
        return metadata.isRefinedPartitioningOver(session.toConnectorSession(connectorId), left.getConnectorHandle(), right.getConnectorHandle());
    }

    @Override
    public PartitioningHandle getPartitioningHandleForExchange(Session session, String catalogName, int partitionCount, List<Type> partitionTypes) {
        CatalogMetadata catalogMetadata = this.getOptionalCatalogMetadata(session, catalogName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Catalog '%s' does not exist", catalogName)));
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
        ConnectorPartitioningHandle connectorPartitioningHandle = metadata.getPartitioningHandleForExchange(session.toConnectorSession(connectorId), partitionCount, partitionTypes);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(connectorId);
        return new PartitioningHandle(Optional.of(connectorId), Optional.of(transaction), connectorPartitioningHandle);
    }

    @Override
    public Optional<Object> getInfo(Session session, TableHandle handle) {
        ConnectorId connectorId = handle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return handle.getLayout().flatMap(tableLayout -> metadata.getInfo(tableLayout));
    }

    @Override
    public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
        if (tableMetadata.getColumns().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table has no columns: " + tableHandle);
        }
        return new TableMetadata(connectorId, tableMetadata);
    }

    @Override
    public TableStatistics getTableStatistics(Session session, TableHandle tableHandle, List<ColumnHandle> columnHandles, Constraint<ColumnHandle> constraint) {
        try {
            ConnectorId connectorId = tableHandle.getConnectorId();
            ConnectorMetadata metadata = this.getMetadata(session, connectorId);
            return metadata.getTableStatistics(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), tableHandle.getLayout(), columnHandles, constraint);
        }
        catch (RuntimeException e) {
            if (SystemSessionProperties.isIgnoreStatsCalculatorFailures(session)) {
                log.error((Throwable)e, "Error occurred when computing stats for query %s", new Object[]{session.getQueryId()});
                return TableStatistics.empty();
            }
            throw e;
        }
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        Map handles = metadata.getColumnHandles(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry mapEntry : handles.entrySet()) {
            map.put((Object)((String)mapEntry.getKey()).toLowerCase(Locale.ENGLISH), mapEntry.getValue());
        }
        return map.build();
    }

    @Override
    public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.getColumnMetadata(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), columnHandle);
    }

    @Override
    public TupleDomain<ColumnHandle> toExplainIOConstraints(Session session, TableHandle tableHandle, TupleDomain<ColumnHandle> constraints) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.toExplainIOConstraints(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), constraints);
    }

    @Override
    public List<QualifiedObjectName> listTables(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet tables = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (ConnectorId connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                ConnectorSession connectorSession = session.toConnectorSession(connectorId);
                metadata.listTables(connectorSession, prefix.getSchemaName()).stream().map(MetadataManager.convertFromSchemaTableName(prefix.getCatalogName())).filter(prefix::matches).forEach(tables::add);
            }
        }
        return ImmutableList.copyOf(tables);
    }

    @Override
    public Map<QualifiedObjectName, List<ColumnMetadata>> listTableColumns(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        HashMap tableColumns = new HashMap();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (ConnectorId connectorId : catalogMetadata.listConnectorIds()) {
                QualifiedObjectName tableName;
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                ConnectorSession connectorSession = session.toConnectorSession(connectorId);
                for (Map.Entry entry : metadata.listTableColumns(connectorSession, tablePrefix).entrySet()) {
                    tableName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    tableColumns.put(tableName, entry.getValue());
                }
                for (Map.Entry entry : metadata.getViews(connectorSession, tablePrefix).entrySet()) {
                    tableName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    ImmutableList.Builder columns = ImmutableList.builder();
                    for (ViewDefinition.ViewColumn column : this.deserializeView(((ConnectorViewDefinition)entry.getValue()).getViewData()).getColumns()) {
                        columns.add((Object)new ColumnMetadata(column.getName(), column.getType()));
                    }
                    tableColumns.put(tableName, columns.build());
                }
            }
        }
        return ImmutableMap.copyOf(tableColumns);
    }

    @Override
    public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schema.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createSchema(session.toConnectorSession(connectorId), schema.getSchemaName(), properties);
    }

    @Override
    public void dropSchema(Session session, CatalogSchemaName schema) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schema.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropSchema(session.toConnectorSession(connectorId), schema.getSchemaName());
    }

    @Override
    public void renameSchema(Session session, CatalogSchemaName source, String target) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, source.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.renameSchema(session.toConnectorSession(connectorId), source.getSchemaName(), target);
    }

    @Override
    public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createTable(session.toConnectorSession(connectorId), tableMetadata, ignoreExisting);
    }

    @Override
    public TableHandle createTemporaryTable(Session session, String catalogName, List<ColumnMetadata> columns, Optional<PartitioningMetadata> partitioningMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTableHandle connectorTableHandle = metadata.createTemporaryTable(session.toConnectorSession(connectorId), columns, partitioningMetadata.map(partitioning -> MetadataManager.createConnectorPartitioningMetadata(connectorId, partitioning)));
        return new TableHandle(connectorId, connectorTableHandle, catalogMetadata.getTransactionHandleFor(connectorId), Optional.empty());
    }

    private static ConnectorPartitioningMetadata createConnectorPartitioningMetadata(ConnectorId connectorId, PartitioningMetadata partitioningMetadata) {
        ConnectorId partitioningConnectorId = partitioningMetadata.getPartitioningHandle().getConnectorId().orElseThrow(() -> new IllegalArgumentException("connectorId is expected to be present in the connector partitioning handle"));
        Preconditions.checkArgument((boolean)connectorId.equals((Object)partitioningConnectorId), (String)"Unexpected partitioning handle connector: %s. Expected: %s.", (Object)partitioningConnectorId, (Object)connectorId);
        return new ConnectorPartitioningMetadata(partitioningMetadata.getPartitioningHandle().getConnectorHandle(), partitioningMetadata.getPartitionColumns());
    }

    @Override
    public void renameTable(Session session, TableHandle tableHandle, QualifiedObjectName newTableName) {
        String catalogName = newTableName.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        if (!tableHandle.getConnectorId().equals((Object)connectorId)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename tables across catalogs");
        }
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.renameTable(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), MetadataUtil.toSchemaTableName(newTableName));
    }

    @Override
    public void renameColumn(Session session, TableHandle tableHandle, ColumnHandle source, String target) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, connectorId);
        metadata.renameColumn(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), source, target.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void addColumn(Session session, TableHandle tableHandle, ColumnMetadata column) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, connectorId);
        metadata.addColumn(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), column);
    }

    @Override
    public void dropColumn(Session session, TableHandle tableHandle, ColumnHandle column) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, connectorId);
        metadata.dropColumn(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), column);
    }

    @Override
    public void dropTable(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, connectorId);
        metadata.dropTable(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
    }

    @Override
    public Optional<NewTableLayout> getInsertLayout(Session session, TableHandle table) {
        ConnectorId connectorId = table.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        return metadata.getInsertLayout(session.toConnectorSession(connectorId), table.getConnectorHandle()).map(layout -> new NewTableLayout(connectorId, catalogMetadata.getTransactionHandleFor(connectorId), (ConnectorNewTableLayout)layout));
    }

    @Override
    public Optional<NewTableLayout> getPreferredShuffleLayoutForInsert(Session session, TableHandle table) {
        ConnectorId connectorId = table.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        return metadata.getPreferredShuffleLayoutForInsert(session.toConnectorSession(connectorId), table.getConnectorHandle()).map(layout -> new NewTableLayout(connectorId, catalogMetadata.getTransactionHandleFor(connectorId), (ConnectorNewTableLayout)layout));
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        return metadata.getStatisticsCollectionMetadataForWrite(session.toConnectorSession(connectorId), tableMetadata);
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadata(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        return metadata.getStatisticsCollectionMetadata(session.toConnectorSession(connectorId), tableMetadata);
    }

    @Override
    public AnalyzeTableHandle beginStatisticsCollection(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(connectorId);
        ConnectorTableHandle connectorTableHandle = metadata.beginStatisticsCollection(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
        return new AnalyzeTableHandle(connectorId, transactionHandle, connectorTableHandle);
    }

    @Override
    public void finishStatisticsCollection(Session session, AnalyzeTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, connectorId);
        catalogMetadata.getMetadata().finishStatisticsCollection(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), computedStatistics);
    }

    @Override
    public Optional<NewTableLayout> getNewTableLayout(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        return metadata.getNewTableLayout(connectorSession, tableMetadata).map(layout -> new NewTableLayout(connectorId, transactionHandle, (ConnectorNewTableLayout)layout));
    }

    @Override
    public Optional<NewTableLayout> getPreferredShuffleLayoutForNewTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        return metadata.getPreferredShuffleLayoutForNewTable(connectorSession, tableMetadata).map(layout -> new NewTableLayout(connectorId, transactionHandle, (ConnectorNewTableLayout)layout));
    }

    @Override
    public void beginQuery(Session session, Set<ConnectorId> connectors) {
        for (ConnectorId connectorId : connectors) {
            ConnectorMetadata metadata = this.getMetadata(session, connectorId);
            ConnectorSession connectorSession = session.toConnectorSession(connectorId);
            metadata.beginQuery(connectorSession);
            this.registerCatalogForQueryId(session.getQueryId(), metadata);
        }
    }

    private void registerCatalogForQueryId(QueryId queryId, ConnectorMetadata metadata) {
        this.catalogsByQueryId.putIfAbsent(queryId.getId(), new ArrayList());
        ((Collection)this.catalogsByQueryId.get(queryId.getId())).add(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupQuery(Session session) {
        try {
            Collection catalogs = (Collection)this.catalogsByQueryId.get(session.getQueryId().getId());
            if (catalogs == null) {
                return;
            }
            for (ConnectorMetadata metadata : catalogs) {
                metadata.cleanupQuery(session.toConnectorSession());
            }
        }
        finally {
            this.catalogsByQueryId.remove(session.getQueryId().getId());
        }
    }

    @Override
    public OutputTableHandle beginCreateTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, Optional<NewTableLayout> layout) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        ConnectorOutputTableHandle handle = metadata.beginCreateTable(connectorSession, tableMetadata, layout.map(NewTableLayout::getLayout));
        return new OutputTableHandle(connectorId, transactionHandle, handle);
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishCreateTable(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.finishCreateTable(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), fragments, computedStatistics);
    }

    @Override
    public InsertTableHandle beginInsert(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(connectorId);
        ConnectorInsertTableHandle handle = metadata.beginInsert(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
        return new InsertTableHandle(tableHandle.getConnectorId(), transactionHandle, handle);
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishInsert(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.finishInsert(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), fragments, computedStatistics);
    }

    @Override
    public ColumnHandle getUpdateRowIdColumnHandle(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.getUpdateRowIdColumnHandle(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
    }

    @Override
    public boolean supportsMetadataDelete(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.supportsMetadataDelete(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), tableHandle.getLayout());
    }

    @Override
    public OptionalLong metadataDelete(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, connectorId);
        return metadata.metadataDelete(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), (ConnectorTableLayoutHandle)tableHandle.getLayout().get());
    }

    @Override
    public TableHandle beginDelete(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, connectorId);
        ConnectorTableHandle newHandle = catalogMetadata.getMetadata().beginDelete(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
        return new TableHandle(tableHandle.getConnectorId(), newHandle, tableHandle.getTransaction(), Optional.empty());
    }

    @Override
    public void finishDelete(Session session, TableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        metadata.finishDelete(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public Optional<ConnectorId> getCatalogHandle(Session session, String catalogName) {
        return this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName).map(CatalogMetadata::getConnectorId);
    }

    @Override
    public Map<String, ConnectorId> getCatalogNames(Session session) {
        return this.transactionManager.getCatalogNames(session.getRequiredTransactionId());
    }

    @Override
    public List<QualifiedObjectName> listViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet views = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (ConnectorId connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                ConnectorSession connectorSession = session.toConnectorSession(connectorId);
                metadata.listViews(connectorSession, prefix.getSchemaName()).stream().map(MetadataManager.convertFromSchemaTableName(prefix.getCatalogName())).filter(prefix::matches).forEach(views::add);
            }
        }
        return ImmutableList.copyOf(views);
    }

    @Override
    public Map<QualifiedObjectName, ViewDefinition> getViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashMap<QualifiedObjectName, ViewDefinition> views = new LinkedHashMap<QualifiedObjectName, ViewDefinition>();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (ConnectorId connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                ConnectorSession connectorSession = session.toConnectorSession(connectorId);
                for (Map.Entry entry : metadata.getViews(connectorSession, tablePrefix).entrySet()) {
                    QualifiedObjectName viewName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    views.put(viewName, this.deserializeView(((ConnectorViewDefinition)entry.getValue()).getViewData()));
                }
            }
        }
        return ImmutableMap.copyOf(views);
    }

    @Override
    public Optional<ViewDefinition> getView(Session session, QualifiedObjectName viewName) {
        ConnectorId connectorId;
        CatalogMetadata catalogMetadata;
        ConnectorMetadata metadata;
        Map views;
        ConnectorViewDefinition view;
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent() && (view = (ConnectorViewDefinition)(views = (metadata = (catalogMetadata = catalog.get()).getMetadataFor(connectorId = catalogMetadata.getConnectorId(session, viewName))).getViews(session.toConnectorSession(connectorId), MetadataUtil.toSchemaTableName(viewName).toSchemaTablePrefix())).get(MetadataUtil.toSchemaTableName(viewName))) != null) {
            ViewDefinition definition = this.deserializeView(view.getViewData());
            if (view.getOwner().isPresent() && !definition.isRunAsInvoker()) {
                definition = definition.withOwner((String)view.getOwner().get());
            }
            return Optional.of(definition);
        }
        return Optional.empty();
    }

    @Override
    public void createView(Session session, String catalogName, ConnectorTableMetadata viewMetadata, String viewData, boolean replace) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createView(session.toConnectorSession(connectorId), viewMetadata, viewData, replace);
    }

    @Override
    public void dropView(Session session, QualifiedObjectName viewName) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropView(session.toConnectorSession(connectorId), MetadataUtil.toSchemaTableName(viewName));
    }

    @Override
    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(Session session, QualifiedObjectName viewName) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorId connectorId = catalogMetadata.getConnectorId(session, viewName);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
            return metadata.getMaterializedView(session.toConnectorSession(connectorId), MetadataUtil.toSchemaTableName(viewName));
        }
        return Optional.empty();
    }

    @Override
    public void createMaterializedView(Session session, String catalogName, ConnectorTableMetadata viewMetadata, ConnectorMaterializedViewDefinition viewDefinition, boolean ignoreExisting) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createMaterializedView(session.toConnectorSession(connectorId), viewMetadata, viewDefinition, ignoreExisting);
    }

    @Override
    public void dropMaterializedView(Session session, QualifiedObjectName viewName) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropMaterializedView(session.toConnectorSession(connectorId), MetadataUtil.toSchemaTableName(viewName));
    }

    @Override
    public MaterializedViewStatus getMaterializedViewStatus(Session session, QualifiedObjectName materializedViewName) {
        Optional<TableHandle> materializedViewHandle = this.getTableHandle(session, materializedViewName);
        ConnectorId connectorId = materializedViewHandle.get().getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.getMaterializedViewStatus(session.toConnectorSession(connectorId), MetadataUtil.toSchemaTableName(materializedViewName));
    }

    @Override
    public InsertTableHandle beginRefreshMaterializedView(Session session, TableHandle tableHandle) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(connectorId);
        ConnectorInsertTableHandle handle = metadata.beginRefreshMaterializedView(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle());
        return new InsertTableHandle(tableHandle.getConnectorId(), transactionHandle, handle);
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        ConnectorMetadata metadata = this.getMetadata(session, connectorId);
        return metadata.finishRefreshMaterializedView(session.toConnectorSession(connectorId), tableHandle.getConnectorHandle(), fragments, computedStatistics);
    }

    @Override
    public List<QualifiedObjectName> getReferencedMaterializedViews(Session session, QualifiedObjectName tableName) {
        ConnectorSession connectorSession;
        ConnectorMetadata metadata;
        Optional materializedViews;
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, tableName.getCatalogName());
        if (catalog.isPresent() && (materializedViews = (metadata = catalog.get().getMetadata()).getReferencedMaterializedViews(connectorSession = session.toConnectorSession(catalog.get().getConnectorId()), MetadataUtil.toSchemaTableName(tableName))).isPresent()) {
            return (List)((List)materializedViews.get()).stream().map(MetadataManager.convertFromSchemaTableName(tableName.getCatalogName())).collect(ImmutableList.toImmutableList());
        }
        return ImmutableList.of();
    }

    @Override
    public Optional<ResolvedIndex> resolveIndex(Session session, TableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        Optional resolvedIndex = metadata.resolveIndex(connectorSession, tableHandle.getConnectorHandle(), indexableColumns, outputColumns, tupleDomain);
        return resolvedIndex.map(resolved -> new ResolvedIndex(tableHandle.getConnectorId(), transaction, (ConnectorResolvedIndex)resolved));
    }

    @Override
    public void createRole(Session session, String role, Optional<PrestoPrincipal> grantor, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createRole(session.toConnectorSession(connectorId), role, grantor);
    }

    @Override
    public void dropRole(Session session, String role, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropRole(session.toConnectorSession(connectorId), role);
    }

    @Override
    public Set<String> listRoles(Session session, String catalog) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (!catalogMetadata.isPresent()) {
            return ImmutableSet.of();
        }
        ConnectorId connectorId = catalogMetadata.get().getConnectorId();
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(connectorId);
        return (Set)metadata.listRoles(connectorSession).stream().map(role -> role.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Set<RoleGrant> listRoleGrants(Session session, String catalog, PrestoPrincipal principal) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (!catalogMetadata.isPresent()) {
            return ImmutableSet.of();
        }
        ConnectorId connectorId = catalogMetadata.get().getConnectorId();
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(connectorId);
        return metadata.listRoleGrants(connectorSession, principal);
    }

    @Override
    public void grantRoles(Session session, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.grantRoles(session.toConnectorSession(connectorId), roles, grantees, withAdminOption, grantor);
    }

    @Override
    public void revokeRoles(Session session, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog);
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.revokeRoles(session.toConnectorSession(connectorId), roles, grantees, adminOptionFor, grantor);
    }

    @Override
    public Set<RoleGrant> listApplicableRoles(Session session, PrestoPrincipal principal, String catalog) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (!catalogMetadata.isPresent()) {
            return ImmutableSet.of();
        }
        ConnectorId connectorId = catalogMetadata.get().getConnectorId();
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(connectorId);
        return ImmutableSet.copyOf((Collection)metadata.listApplicableRoles(connectorSession, principal));
    }

    @Override
    public Set<String> listEnabledRoles(Session session, String catalog) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (!catalogMetadata.isPresent()) {
            return ImmutableSet.of();
        }
        ConnectorId connectorId = catalogMetadata.get().getConnectorId();
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(connectorId);
        return ImmutableSet.copyOf((Collection)metadata.listEnabledRoles(connectorSession));
    }

    @Override
    public void grantTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.grantTablePrivileges(session.toConnectorSession(connectorId), MetadataUtil.toSchemaTableName(tableName), privileges, grantee, grantOption);
    }

    @Override
    public void revokeTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        ConnectorId connectorId = catalogMetadata.getConnectorId();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.revokeTablePrivileges(session.toConnectorSession(connectorId), MetadataUtil.toSchemaTableName(tableName), privileges, grantee, grantOption);
    }

    @Override
    public List<GrantInfo> listTablePrivileges(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        ImmutableSet.Builder grantInfos = ImmutableSet.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getConnectorId());
            for (ConnectorId connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                grantInfos.addAll((Iterable)metadata.listTablePrivileges(connectorSession, tablePrefix));
            }
        }
        return ImmutableList.copyOf((Collection)grantInfos.build());
    }

    @Override
    public ListenableFuture<Void> commitPageSinkAsync(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        return MoreFutures.toListenableFuture((CompletableFuture)metadata.commitPageSinkAsync(connectorSession, tableHandle.getConnectorHandle(), fragments));
    }

    @Override
    public ListenableFuture<Void> commitPageSinkAsync(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorId connectorId = tableHandle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        return MoreFutures.toListenableFuture((CompletableFuture)metadata.commitPageSinkAsync(connectorSession, tableHandle.getConnectorHandle(), fragments));
    }

    @Override
    public MetadataUpdates getMetadataUpdateResults(Session session, QueryManager queryManager, MetadataUpdates metadataUpdateRequests, QueryId queryId) {
        ConnectorId connectorId = metadataUpdateRequests.getConnectorId();
        ConnectorMetadata metadata = this.getCatalogMetadata(session, connectorId).getMetadata();
        if (queryManager != null && !this.queriesWithRegisteredCallbacks.contains(queryId)) {
            queryManager.addStateChangeListener(queryId, state -> {
                if (state.isDone()) {
                    metadata.doMetadataUpdateCleanup(queryId);
                    this.queriesWithRegisteredCallbacks.remove(queryId);
                }
            });
            this.queriesWithRegisteredCallbacks.add(queryId);
        }
        List metadataResults = metadata.getMetadataUpdateResults(metadataUpdateRequests.getMetadataUpdates(), queryId);
        return new MetadataUpdates(connectorId, metadataResults);
    }

    @Override
    public FunctionAndTypeManager getFunctionAndTypeManager() {
        return this.functionAndTypeManager;
    }

    @Override
    public ProcedureRegistry getProcedureRegistry() {
        return this.procedures;
    }

    @Override
    public BlockEncodingSerde getBlockEncodingSerde() {
        return this.blockEncodingSerde;
    }

    @Override
    public SessionPropertyManager getSessionPropertyManager() {
        return this.sessionPropertyManager;
    }

    @Override
    public SchemaPropertyManager getSchemaPropertyManager() {
        return this.schemaPropertyManager;
    }

    @Override
    public TablePropertyManager getTablePropertyManager() {
        return this.tablePropertyManager;
    }

    @Override
    public ColumnPropertyManager getColumnPropertyManager() {
        return this.columnPropertyManager;
    }

    @Override
    public AnalyzePropertyManager getAnalyzePropertyManager() {
        return this.analyzePropertyManager;
    }

    @Override
    public Set<ConnectorCapabilities> getConnectorCapabilities(Session session, ConnectorId connectorId) {
        return this.getCatalogMetadata(session, connectorId).getConnectorCapabilities();
    }

    @Override
    public TableLayoutFilterCoverage getTableLayoutFilterCoverage(Session session, TableHandle tableHandle, Set<String> relevantPartitionColumns) {
        Objects.requireNonNull(tableHandle, "tableHandle cannot be null");
        Objects.requireNonNull(relevantPartitionColumns, "relevantPartitionKeys cannot be null");
        if (!tableHandle.getLayout().isPresent()) {
            return TableLayoutFilterCoverage.NOT_APPLICABLE;
        }
        ConnectorId connectorId = tableHandle.getConnectorId();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, connectorId);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
        return metadata.getTableLayoutFilterCoverage((ConnectorTableLayoutHandle)tableHandle.getLayout().get(), relevantPartitionColumns);
    }

    private ViewDefinition deserializeView(String data) {
        try {
            return (ViewDefinition)this.viewCodec.fromJson(data);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, "Invalid view JSON: " + data, (Throwable)e);
        }
    }

    private Optional<CatalogMetadata> getOptionalCatalogMetadata(Session session, String catalogName) {
        return this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName);
    }

    private CatalogMetadata getCatalogMetadata(Session session, ConnectorId connectorId) {
        return this.transactionManager.getCatalogMetadata(session.getRequiredTransactionId(), connectorId);
    }

    private CatalogMetadata getCatalogMetadataForWrite(Session session, String catalogName) {
        return this.transactionManager.getCatalogMetadataForWrite(session.getRequiredTransactionId(), catalogName);
    }

    private CatalogMetadata getCatalogMetadataForWrite(Session session, ConnectorId connectorId) {
        return this.transactionManager.getCatalogMetadataForWrite(session.getRequiredTransactionId(), connectorId);
    }

    private ConnectorMetadata getMetadata(Session session, ConnectorId connectorId) {
        return this.getCatalogMetadata(session, connectorId).getMetadataFor(connectorId);
    }

    private ConnectorMetadata getMetadataForWrite(Session session, ConnectorId connectorId) {
        return this.getCatalogMetadataForWrite(session, connectorId).getMetadata();
    }

    private static JsonCodec<ViewDefinition> createTestingViewCodec(FunctionAndTypeManager functionAndTypeManager) {
        JsonObjectMapperProvider provider = new JsonObjectMapperProvider();
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TypeDeserializer(functionAndTypeManager))));
        return new JsonCodecFactory((Provider)provider).jsonCodec(ViewDefinition.class);
    }

    private boolean canResolveOperator(OperatorType operatorType, List<TypeSignatureProvider> argumentTypes) {
        try {
            this.getFunctionAndTypeManager().resolveOperator(operatorType, argumentTypes);
            return true;
        }
        catch (OperatorNotFoundException e) {
            return false;
        }
    }

    private ConnectorTableLayoutHandle resolveTableLayout(Session session, TableHandle tableHandle) {
        if (tableHandle.getLayout().isPresent()) {
            return (ConnectorTableLayoutHandle)tableHandle.getLayout().get();
        }
        TableLayoutResult result = this.getLayout(session, tableHandle, (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty());
        return result.getLayout().getLayoutHandle();
    }

    @VisibleForTesting
    public Map<String, Collection<ConnectorMetadata>> getCatalogsByQueryId() {
        return ImmutableMap.copyOf(this.catalogsByQueryId);
    }

    public static Function<SchemaTableName, QualifiedObjectName> convertFromSchemaTableName(String catalogName) {
        return input -> new QualifiedObjectName(catalogName, input.getSchemaName(), input.getTableName());
    }
}

