/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler.nodeSelection;

import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.scheduler.NodeMap;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.ResettableRandomizedIterator;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelection;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.google.common.base.Verify;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RandomNodeSelection
implements NodeSelection {
    private final boolean includeCoordinator;
    private final int minCandidates;
    private ResettableRandomizedIterator<InternalNode> randomCandidates;

    public RandomNodeSelection(NodeMap nodeMap, boolean includeCoordinator, int minCandidates, int maxTasksPerStage, List<RemoteTask> existingTasks) {
        Objects.requireNonNull(nodeMap, "nodeMap is null");
        Objects.requireNonNull(existingTasks, "existingTasks is null");
        this.includeCoordinator = includeCoordinator;
        this.minCandidates = minCandidates;
        this.randomCandidates = this.getRandomCandidates(maxTasksPerStage, nodeMap, existingTasks);
    }

    @Override
    public List<InternalNode> pickNodes(Split split) {
        this.randomCandidates.reset();
        return NodeScheduler.selectNodes(this.minCandidates, this.randomCandidates);
    }

    private ResettableRandomizedIterator<InternalNode> getRandomCandidates(int limit, NodeMap nodeMap, List<RemoteTask> existingTasks) {
        List existingNodes = existingTasks.stream().map(remoteTask -> nodeMap.getActiveNodesByNodeId().get(remoteTask.getNodeId())).filter(Objects::nonNull).collect(Collectors.toList());
        int alreadySelectedNodeCount = existingNodes.size();
        int nodeCount = nodeMap.getActiveNodesByNodeId().size();
        if (alreadySelectedNodeCount < limit && alreadySelectedNodeCount < nodeCount) {
            List<InternalNode> moreNodes = NodeScheduler.selectNodes(limit - alreadySelectedNodeCount, NodeScheduler.randomizedNodes(nodeMap, this.includeCoordinator, Sets.newHashSet(existingNodes)));
            existingNodes.addAll(moreNodes);
        }
        Verify.verify((boolean)existingNodes.stream().allMatch(Objects::nonNull), (String)"existingNodes list must not contain any nulls", (Object[])new Object[0]);
        return new ResettableRandomizedIterator<InternalNode>(existingNodes);
    }
}

