/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.resourceGroups.UpdateablePriorityQueue;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;

final class TieredQueue<E>
implements UpdateablePriorityQueue<E> {
    private final UpdateablePriorityQueue<E> highPriorityQueue;
    private final UpdateablePriorityQueue<E> lowPriorityQueue;

    public TieredQueue(UpdateablePriorityQueue<E> highPriorityQueue, UpdateablePriorityQueue<E> lowPriorityQueue) {
        this.highPriorityQueue = Objects.requireNonNull(highPriorityQueue, "highPriorityQueue is null");
        this.lowPriorityQueue = Objects.requireNonNull(lowPriorityQueue, "lowPriorityQueue is null");
    }

    public TieredQueue(Supplier<UpdateablePriorityQueue<E>> supplier) {
        this(supplier.get(), supplier.get());
    }

    @Override
    public boolean addOrUpdate(E element, long priority) {
        return this.lowPriorityQueue.addOrUpdate(element, priority);
    }

    public boolean prioritize(E element, long priority) {
        return this.highPriorityQueue.addOrUpdate(element, priority);
    }

    @Override
    public boolean contains(E element) {
        return this.highPriorityQueue.contains(element) || this.lowPriorityQueue.contains(element);
    }

    @Override
    public boolean remove(E element) {
        boolean highPriorityRemoved = this.highPriorityQueue.remove(element);
        boolean lowPriorityRemoved = this.lowPriorityQueue.remove(element);
        return highPriorityRemoved || lowPriorityRemoved;
    }

    @Override
    public E poll() {
        Iterator<E> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        E element = iterator.next();
        iterator.remove();
        return element;
    }

    @Override
    public E peek() {
        Iterator<E> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    @Override
    public int size() {
        return this.highPriorityQueue.size() + this.lowPriorityQueue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.highPriorityQueue.isEmpty() && this.lowPriorityQueue.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.concat(this.highPriorityQueue.iterator(), this.lowPriorityQueue.iterator());
    }

    public UpdateablePriorityQueue<E> getLowPriorityQueue() {
        return this.lowPriorityQueue;
    }
}

