/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.inject.Inject;

public class KillQueryProcedure {
    private static final MethodHandle KILL_QUERY = Reflection.methodHandle(KillQueryProcedure.class, "killQuery", String.class, String.class);
    private final QueryManager queryManager;

    @Inject
    public KillQueryProcedure(QueryManager queryManager) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
    }

    @UsedByGeneratedCode
    public void killQuery(String queryId, String message) {
        QueryId query = KillQueryProcedure.parseQueryId(queryId);
        try {
            QueryState state = this.queryManager.getQueryState(query);
            if (state.isDone()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Target query is not running: " + queryId);
            }
            this.queryManager.failQuery(query, KillQueryProcedure.createKillQueryException(message));
            if (!StandardErrorCode.ADMINISTRATIVELY_KILLED.toErrorCode().equals((Object)this.queryManager.getQueryInfo(query).getErrorCode())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Target query is not running: " + queryId);
            }
        }
        catch (NoSuchElementException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Target query not found: " + queryId);
        }
    }

    public Procedure getProcedure() {
        return new Procedure("runtime", "kill_query", (List)ImmutableList.builder().add((Object)new Procedure.Argument("query_id", "varchar")).add((Object)new Procedure.Argument("message", "varchar")).build(), KILL_QUERY.bindTo(this));
    }

    public static PrestoException createKillQueryException(String message) {
        return new PrestoException((ErrorCodeSupplier)StandardErrorCode.ADMINISTRATIVELY_KILLED, "Query killed. " + (Strings.isNullOrEmpty((String)message) ? "No message provided." : "Message: " + message));
    }

    public static PrestoException createPreemptQueryException(String message) {
        return new PrestoException((ErrorCodeSupplier)StandardErrorCode.ADMINISTRATIVELY_PREEMPTED, "Query preempted. " + (Strings.isNullOrEmpty((String)message) ? "No message provided." : "Message: " + message));
    }

    private static QueryId parseQueryId(String queryId) {
        try {
            return QueryId.valueOf((String)queryId);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, (Throwable)e);
        }
    }
}

