/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.LongUnaryOperator;

public class PeriodicTaskExecutor
implements AutoCloseable {
    private final long delayTargetMillis;
    private final ScheduledExecutorService executor;
    private final Runnable runnable;
    private final LongUnaryOperator nextDelayFunction;
    private volatile long delayMillis;
    private volatile ScheduledFuture<?> scheduledFuture;
    private volatile boolean stopped;

    public PeriodicTaskExecutor(long delayTargetMillis, ScheduledExecutorService executor, Runnable runnable) {
        this(delayTargetMillis, executor, runnable, PeriodicTaskExecutor::nextDelayWithJitterMillis);
    }

    public PeriodicTaskExecutor(long delayTargetMillis, ScheduledExecutorService executor, Runnable runnable, LongUnaryOperator nextDelayFunction) {
        Preconditions.checkArgument((delayTargetMillis > 0L ? 1 : 0) != 0, (Object)"delayTargetMillis must be > 0");
        this.delayTargetMillis = delayTargetMillis;
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.runnable = Objects.requireNonNull(runnable, "runnable is null");
        this.nextDelayFunction = Objects.requireNonNull(nextDelayFunction, "nextDelayFunction is null");
        this.tick();
    }

    private void tick() {
        this.scheduledFuture = this.executor.schedule(this::run, this.delayMillis, TimeUnit.MILLISECONDS);
    }

    private void run() {
        this.forceRun();
        this.delayMillis = this.nextDelayFunction.applyAsLong(this.delayTargetMillis);
        if (!this.stopped) {
            this.tick();
        }
    }

    public void forceRun() {
        this.executor.execute(this.runnable);
    }

    public void stop() {
        this.stopped = true;
        this.scheduledFuture.cancel(false);
    }

    private static long nextDelayWithJitterMillis(long delayTargetMillis) {
        double minSleepTimeMillis = (double)delayTargetMillis / 2.0;
        return Math.round(minSleepTimeMillis + ThreadLocalRandom.current().nextDouble() * (double)delayTargetMillis);
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }
}

