/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.transaction;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class TransactionManagerConfig {
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings().withKeyValueSeparator('=');
    private Duration idleCheckInterval = new Duration(1.0, TimeUnit.MINUTES);
    private Duration idleTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private int maxFinishingConcurrency = 1;
    private Map<String, String> companionCatalogs = ImmutableMap.of();

    @MinDuration(value="1ms")
    @NotNull
    public Duration getIdleCheckInterval() {
        return this.idleCheckInterval;
    }

    @Config(value="transaction.idle-check-interval")
    @ConfigDescription(value="Time interval between idle transactions checks")
    public TransactionManagerConfig setIdleCheckInterval(Duration idleCheckInterval) {
        this.idleCheckInterval = idleCheckInterval;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @Config(value="transaction.idle-timeout")
    @ConfigDescription(value="Amount of time before an inactive transaction is considered expired")
    public TransactionManagerConfig setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxFinishingConcurrency() {
        return this.maxFinishingConcurrency;
    }

    @Config(value="transaction.max-finishing-concurrency")
    @ConfigDescription(value="Maximum parallelism for committing or aborting a transaction")
    public TransactionManagerConfig setMaxFinishingConcurrency(int maxFinishingConcurrency) {
        this.maxFinishingConcurrency = maxFinishingConcurrency;
        return this;
    }

    @NotNull
    public Map<String, String> getCompanionCatalogs() {
        return this.companionCatalogs;
    }

    @Config(value="transaction.companion-catalogs")
    @ConfigDescription(value="Companion catalogs: catalog_name1=catalog_name2,catalog_name3=catalog_name4,...")
    public TransactionManagerConfig setCompanionCatalogs(String extraAccessibleCatalogs) {
        this.companionCatalogs = MAP_SPLITTER.split((CharSequence)Strings.nullToEmpty((String)extraAccessibleCatalogs));
        return this;
    }
}

