/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.SortExpressionContext;
import com.facebook.presto.sql.planner.SortExpressionExtractor;
import com.facebook.presto.sql.planner.plan.AbstractJoinNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class JoinNode
extends AbstractJoinNode {
    private final Type type;
    private final PlanNode left;
    private final PlanNode right;
    private final List<EquiJoinClause> criteria;
    private final List<VariableReferenceExpression> outputVariables;
    private final Optional<RowExpression> filter;
    private final Optional<VariableReferenceExpression> leftHashVariable;
    private final Optional<VariableReferenceExpression> rightHashVariable;
    private final Optional<DistributionType> distributionType;
    private final Map<String, VariableReferenceExpression> dynamicFilters;

    @JsonCreator
    public JoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="left") PlanNode left, @JsonProperty(value="right") PlanNode right, @JsonProperty(value="criteria") List<EquiJoinClause> criteria, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="filter") Optional<RowExpression> filter, @JsonProperty(value="leftHashVariable") Optional<VariableReferenceExpression> leftHashVariable, @JsonProperty(value="rightHashVariable") Optional<VariableReferenceExpression> rightHashVariable, @JsonProperty(value="distributionType") Optional<DistributionType> distributionType, @JsonProperty(value="dynamicFilters") Map<String, VariableReferenceExpression> dynamicFilters) {
        super(id);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        Objects.requireNonNull(criteria, "criteria is null");
        Objects.requireNonNull(outputVariables, "outputVariables is null");
        Objects.requireNonNull(filter, "filter is null");
        Objects.requireNonNull(leftHashVariable, "leftHashVariable is null");
        Objects.requireNonNull(rightHashVariable, "rightHashVariable is null");
        Objects.requireNonNull(distributionType, "distributionType is null");
        Objects.requireNonNull(dynamicFilters, "dynamicFilters is null");
        this.type = type;
        this.left = left;
        this.right = right;
        this.criteria = ImmutableList.copyOf(criteria);
        this.outputVariables = ImmutableList.copyOf(outputVariables);
        this.filter = filter;
        this.leftHashVariable = leftHashVariable;
        this.rightHashVariable = rightHashVariable;
        this.distributionType = distributionType;
        this.dynamicFilters = ImmutableMap.copyOf(dynamicFilters);
        ImmutableSet inputVariables = ImmutableSet.builder().addAll((Iterable)left.getOutputVariables()).addAll((Iterable)right.getOutputVariables()).build();
        Preconditions.checkArgument((boolean)new HashSet(inputVariables).containsAll(outputVariables), (Object)"Left and right join inputs do not contain all output variables");
        Preconditions.checkArgument((!this.isCrossJoin() || inputVariables.size() == outputVariables.size() ? 1 : 0) != 0, (Object)"Cross join does not support output variables pruning or reordering");
        Preconditions.checkArgument((!criteria.isEmpty() || !leftHashVariable.isPresent() ? 1 : 0) != 0, (Object)"Left hash variable is only valid in an equijoin");
        Preconditions.checkArgument((!criteria.isEmpty() || !rightHashVariable.isPresent() ? 1 : 0) != 0, (Object)"Right hash variable is only valid in an equijoin");
        if (distributionType.isPresent()) {
            Preconditions.checkArgument((distributionType.get() != DistributionType.REPLICATED || !type.mustPartition() ? 1 : 0) != 0, (String)"%s join do not work with %s distribution type", (Object)((Object)type), (Object)((Object)distributionType.get()));
            Preconditions.checkArgument((distributionType.get() != DistributionType.PARTITIONED || !type.mustReplicate(criteria) ? 1 : 0) != 0, (String)"Equi criteria are empty, so %s join should not have %s distribution type", (Object)((Object)type), (Object)((Object)distributionType.get()));
        }
        for (VariableReferenceExpression variableReferenceExpression : dynamicFilters.values()) {
            Preconditions.checkArgument((boolean)right.getOutputVariables().contains(variableReferenceExpression), (Object)String.format("Right join input doesn't contain symbol for dynamic filter: %s, rightVariables: %s, dynamicFilters.values(): %s", variableReferenceExpression, Arrays.toString(right.getOutputVariables().toArray()), Arrays.toString(dynamicFilters.values().toArray())));
        }
    }

    public JoinNode flipChildren() {
        return new JoinNode(this.getId(), JoinNode.flipType(this.type), this.right, this.left, JoinNode.flipJoinCriteria(this.criteria), JoinNode.flipOutputVariables(this.getOutputVariables(), this.left, this.right), this.filter, this.rightHashVariable, this.leftHashVariable, this.distributionType, (Map<String, VariableReferenceExpression>)ImmutableMap.of());
    }

    private static Type flipType(Type type) {
        switch (type) {
            case INNER: {
                return Type.INNER;
            }
            case FULL: {
                return Type.FULL;
            }
            case LEFT: {
                return Type.RIGHT;
            }
            case RIGHT: {
                return Type.LEFT;
            }
        }
        throw new IllegalStateException("No inverse defined for join type: " + (Object)((Object)type));
    }

    private static List<EquiJoinClause> flipJoinCriteria(List<EquiJoinClause> joinCriteria) {
        return (List)joinCriteria.stream().map(EquiJoinClause::flip).collect(ImmutableList.toImmutableList());
    }

    private static List<VariableReferenceExpression> flipOutputVariables(List<VariableReferenceExpression> outputVariables, PlanNode left, PlanNode right) {
        List leftVariables = outputVariables.stream().filter(variable -> left.getOutputVariables().contains(variable)).collect(Collectors.toList());
        List rightVariables = outputVariables.stream().filter(variable -> right.getOutputVariables().contains(variable)).collect(Collectors.toList());
        return ImmutableList.builder().addAll(rightVariables).addAll(leftVariables).build();
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public PlanNode getLeft() {
        return this.left;
    }

    @Override
    public PlanNode getProbe() {
        return this.left;
    }

    @JsonProperty
    public PlanNode getRight() {
        return this.right;
    }

    @Override
    public PlanNode getBuild() {
        return this.right;
    }

    @JsonProperty
    public List<EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    @JsonProperty
    public Optional<RowExpression> getFilter() {
        return this.filter;
    }

    public Optional<SortExpressionContext> getSortExpressionContext(FunctionAndTypeManager functionAndTypeManager) {
        return this.filter.flatMap(filter -> SortExpressionExtractor.extractSortExpression((Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)this.right.getOutputVariables()), filter, functionAndTypeManager));
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getLeftHashVariable() {
        return this.leftHashVariable;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getRightHashVariable() {
        return this.rightHashVariable;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public Optional<DistributionType> getDistributionType() {
        return this.distributionType;
    }

    @Override
    @JsonProperty
    public Map<String, VariableReferenceExpression> getDynamicFilters() {
        return this.dynamicFilters;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new JoinNode(this.getId(), this.type, newChildren.get(0), newChildren.get(1), this.criteria, this.outputVariables, this.filter, this.leftHashVariable, this.rightHashVariable, this.distributionType, this.dynamicFilters);
    }

    public JoinNode withDistributionType(DistributionType distributionType) {
        return new JoinNode(this.getId(), this.type, this.left, this.right, this.criteria, this.outputVariables, this.filter, this.leftHashVariable, this.rightHashVariable, Optional.of(distributionType), this.dynamicFilters);
    }

    public boolean isCrossJoin() {
        return this.criteria.isEmpty() && !this.filter.isPresent() && this.type == Type.INNER;
    }

    public static class EquiJoinClause {
        private final VariableReferenceExpression left;
        private final VariableReferenceExpression right;

        @JsonCreator
        public EquiJoinClause(@JsonProperty(value="left") VariableReferenceExpression left, @JsonProperty(value="right") VariableReferenceExpression right) {
            this.left = Objects.requireNonNull(left, "left is null");
            this.right = Objects.requireNonNull(right, "right is null");
        }

        @JsonProperty
        public VariableReferenceExpression getLeft() {
            return this.left;
        }

        @JsonProperty
        public VariableReferenceExpression getRight() {
            return this.right;
        }

        public EquiJoinClause flip() {
            return new EquiJoinClause(this.right, this.left);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            EquiJoinClause other = (EquiJoinClause)obj;
            return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
        }

        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }

        public String toString() {
            return String.format("%s = %s", this.left, this.right);
        }
    }

    public static enum Type {
        INNER("InnerJoin"),
        LEFT("LeftJoin"),
        RIGHT("RightJoin"),
        FULL("FullJoin");

        private final String joinLabel;

        private Type(String joinLabel) {
            this.joinLabel = joinLabel;
        }

        public String getJoinLabel() {
            return this.joinLabel;
        }

        public boolean mustPartition() {
            return this == RIGHT || this == FULL;
        }

        public boolean mustReplicate(List<EquiJoinClause> criteria) {
            return criteria.isEmpty() && (this == INNER || this == LEFT);
        }
    }

    public static enum DistributionType {
        PARTITIONED,
        REPLICATED;

    }
}

