/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class InvokeFunctionBytecodeExpression
extends BytecodeExpression {
    private final BytecodeNode invocation;
    private final String oneLineDescription;

    public static BytecodeExpression invokeFunction(Scope scope, CachedInstanceBinder cachedInstanceBinder, String name, BuiltInScalarFunctionImplementation function, BytecodeExpression ... parameters) {
        return InvokeFunctionBytecodeExpression.invokeFunction(scope, cachedInstanceBinder, name, function, (List<BytecodeExpression>)ImmutableList.copyOf((Object[])parameters));
    }

    public static BytecodeExpression invokeFunction(Scope scope, CachedInstanceBinder cachedInstanceBinder, String name, BuiltInScalarFunctionImplementation function, List<BytecodeExpression> parameters) {
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(function, "function is null");
        Optional<BytecodeNode> instance = Optional.empty();
        if (function.getInstanceFactory().isPresent()) {
            FieldDefinition field = cachedInstanceBinder.getCachedInstance(function.getInstanceFactory().get());
            instance = Optional.of(scope.getThis().getField(field));
        }
        return new InvokeFunctionBytecodeExpression(scope, cachedInstanceBinder.getCallSiteBinder(), name, function, instance, parameters);
    }

    private InvokeFunctionBytecodeExpression(Scope scope, CallSiteBinder binder, String name, BuiltInScalarFunctionImplementation function, Optional<BytecodeNode> instance, List<BytecodeExpression> parameters) {
        super(ParameterizedType.type((Class)Primitives.unwrap((Class)function.getMethodHandle().type().returnType())));
        this.invocation = BytecodeUtils.generateInvocation(scope, name, function, instance, (List)parameters.stream().map(BytecodeNode.class::cast).collect(ImmutableList.toImmutableList()), binder);
        this.oneLineDescription = name + "(" + Joiner.on((String)", ").join(parameters) + ")";
    }

    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return this.invocation;
    }

    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    protected String formatOneLine() {
        return this.oneLineDescription;
    }
}

