/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.PlanOptimizers;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.planPrinter.IOPlanPrinter;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class QueryExplainer {
    private final List<PlanOptimizer> planOptimizers;
    private final PlanFragmenter planFragmenter;
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final SqlParser sqlParser;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final Map<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask;
    private final PlanChecker planChecker;

    @Inject
    public QueryExplainer(PlanOptimizers planOptimizers, PlanFragmenter planFragmenter, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator, Map<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask, PlanChecker planChecker) {
        this(planOptimizers.getPlanningTimeOptimizers(), planFragmenter, metadata, accessControl, sqlParser, statsCalculator, costCalculator, dataDefinitionTask, planChecker);
    }

    public QueryExplainer(List<PlanOptimizer> planOptimizers, PlanFragmenter planFragmenter, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator, Map<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask, PlanChecker planChecker) {
        this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.dataDefinitionTask = ImmutableMap.copyOf(Objects.requireNonNull(dataDefinitionTask, "dataDefinitionTask is null"));
        this.planChecker = Objects.requireNonNull(planChecker, "planChecker is null");
    }

    public Analysis analyze(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        Analyzer analyzer = new Analyzer(session, this.metadata, this.sqlParser, this.accessControl, Optional.of(this), parameters, warningCollector);
        return analyzer.analyze(statement);
    }

    public String getPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, boolean verbose, WarningCollector warningCollector) {
        DataDefinitionTask<?> task = this.dataDefinitionTask.get(statement.getClass());
        if (task != null) {
            return QueryExplainer.explainTask(statement, task, parameters);
        }
        switch (planType) {
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), this.metadata.getFunctionAndTypeManager(), plan.getStatsAndCosts(), session, 0, verbose);
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.textDistributedPlan(subPlan, this.metadata.getFunctionAndTypeManager(), session, verbose);
            }
            case IO: {
                return IOPlanPrinter.textIOPlan(this.getLogicalPlan(session, statement, parameters, warningCollector).getRoot(), this.metadata, session);
            }
        }
        throw new IllegalArgumentException("Unhandled plan type: " + planType);
    }

    private static <T extends Statement> String explainTask(Statement statement, DataDefinitionTask<T> task, List<Expression> parameters) {
        return task.explain(statement, parameters);
    }

    public String getGraphvizPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector) {
        DataDefinitionTask<?> task = this.dataDefinitionTask.get(statement.getClass());
        if (task != null) {
            return QueryExplainer.explainTask(statement, task, parameters);
        }
        switch (planType) {
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.graphvizLogicalPlan(plan.getRoot(), plan.getTypes(), session, this.metadata.getFunctionAndTypeManager());
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.graphvizDistributedPlan(subPlan, session, this.metadata.getFunctionAndTypeManager());
            }
        }
        throw new IllegalArgumentException("Unhandled plan type: " + planType);
    }

    public String getJsonPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector) {
        DataDefinitionTask<?> task = this.dataDefinitionTask.get(statement.getClass());
        if (task != null) {
            return QueryExplainer.explainTask(statement, task, parameters);
        }
        switch (planType) {
            case IO: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return IOPlanPrinter.textIOPlan(plan.getRoot(), this.metadata, session);
            }
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.jsonLogicalPlan(plan.getRoot(), plan.getTypes(), this.metadata.getFunctionAndTypeManager(), plan.getStatsAndCosts(), session);
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.jsonDistributedPlan(subPlan);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported explain plan type %s for JSON format", planType));
    }

    public Plan getLogicalPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        return this.getLogicalPlan(session, statement, parameters, warningCollector, new PlanNodeIdAllocator());
    }

    public Plan getLogicalPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector, PlanNodeIdAllocator idAllocator) {
        Analysis analysis = this.analyze(session, statement, parameters, warningCollector);
        LogicalPlanner logicalPlanner = new LogicalPlanner(true, session, this.planOptimizers, idAllocator, this.metadata, this.sqlParser, this.statsCalculator, this.costCalculator, warningCollector, this.planChecker);
        return logicalPlanner.plan(analysis);
    }

    public SubPlan getDistributedPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector, idAllocator);
        return this.planFragmenter.createSubPlans(session, plan, false, idAllocator, warningCollector);
    }
}

