/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.Table;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PredicateStitcher
extends AstVisitor<Node, PredicateStitcherContext> {
    private final Map<SchemaTableName, Expression> predicates;
    private final Session session;

    public PredicateStitcher(Session session, Map<SchemaTableName, Expression> predicates) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.predicates = Objects.requireNonNull(predicates, "predicates is null");
    }

    public Node process(Node node, PredicateStitcherContext context) {
        return (Node)super.process(node, (Object)context);
    }

    protected Node visitQuery(Query node, PredicateStitcherContext context) {
        return new Query(node.getWith(), (QueryBody)this.process((Node)node.getQueryBody(), context), node.getOrderBy(), node.getLimit());
    }

    protected Node visitQuerySpecification(QuerySpecification node, PredicateStitcherContext context) {
        if (node.getFrom().isPresent()) {
            return new QuerySpecification(node.getSelect(), Optional.of((Relation)this.process((Node)node.getFrom().get(), context)), node.getWhere(), node.getGroupBy(), node.getHaving(), node.getOrderBy(), node.getLimit());
        }
        return node;
    }

    protected Node visitJoin(Join node, PredicateStitcherContext context) {
        Relation rewrittenLeft = (Relation)this.process((Node)node.getLeft(), context);
        Relation rewrittenRight = (Relation)this.process((Node)node.getRight(), context);
        return new Join(node.getType(), rewrittenLeft, rewrittenRight, node.getCriteria());
    }

    protected Node visitAliasedRelation(AliasedRelation node, PredicateStitcherContext context) {
        context.setCreateAlias(false);
        AliasedRelation aliasedRelation = new AliasedRelation((Relation)this.process((Node)node.getRelation(), context), node.getAlias(), node.getColumnNames());
        context.setCreateAlias(true);
        return aliasedRelation;
    }

    protected Node visitTable(Table table, PredicateStitcherContext context) {
        SchemaTableName schemaTableName = MetadataUtil.toSchemaTableName(MetadataUtil.createQualifiedObjectName(this.session, (Node)table, table.getName()));
        if (!this.predicates.containsKey(schemaTableName)) {
            return table;
        }
        QuerySpecification queryWithPredicateStitching = new QuerySpecification(QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), Optional.of(table), Optional.of(this.predicates.remove(schemaTableName)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        Relation subquery = QueryUtil.subquery((Query)new Query(Optional.empty(), (QueryBody)queryWithPredicateStitching, Optional.empty(), Optional.empty()));
        if (context.isCreateAlias()) {
            return new AliasedRelation(subquery, QueryUtil.identifier((String)schemaTableName.getTableName()), null);
        }
        return subquery;
    }

    protected static final class PredicateStitcherContext {
        private boolean createAlias = true;

        protected PredicateStitcherContext() {
        }

        public boolean isCreateAlias() {
            return this.createAlias;
        }

        public void setCreateAlias(boolean createAlias) {
            this.createAlias = createAlias;
        }
    }
}

