/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.configuration.Config;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class ServerConfig {
    private boolean resourceManager;
    private boolean resourceManagerEnabled;
    private boolean coordinator = true;
    private String prestoVersion = this.getClass().getPackage().getImplementationVersion();
    private String dataSources;
    private boolean includeExceptionInResponse = true;
    private Duration gracePeriod = new Duration(2.0, TimeUnit.MINUTES);
    private boolean enhancedErrorReporting = true;
    private boolean queryResultsCompressionEnabled = true;

    public boolean isResourceManager() {
        return this.resourceManager;
    }

    @Config(value="resource-manager")
    public ServerConfig setResourceManager(boolean resourceManager) {
        this.resourceManager = resourceManager;
        return this;
    }

    public boolean isResourceManagerEnabled() {
        return this.resourceManagerEnabled;
    }

    @Config(value="resource-manager-enabled")
    public ServerConfig setResourceManagerEnabled(boolean resourceManagerEnabled) {
        this.resourceManagerEnabled = resourceManagerEnabled;
        return this;
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    @Config(value="coordinator")
    public ServerConfig setCoordinator(boolean coordinator) {
        this.coordinator = coordinator;
        return this;
    }

    @NotNull(message="presto.version must be provided when it cannot be automatically determined")
    public @NotNull(message="presto.version must be provided when it cannot be automatically determined") String getPrestoVersion() {
        return this.prestoVersion;
    }

    @Config(value="presto.version")
    public ServerConfig setPrestoVersion(String prestoVersion) {
        this.prestoVersion = prestoVersion;
        return this;
    }

    @Deprecated
    public String getDataSources() {
        return this.dataSources;
    }

    @Deprecated
    @Config(value="datasources")
    public ServerConfig setDataSources(String dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    public boolean isIncludeExceptionInResponse() {
        return this.includeExceptionInResponse;
    }

    @Config(value="http.include-exception-in-response")
    public ServerConfig setIncludeExceptionInResponse(boolean includeExceptionInResponse) {
        this.includeExceptionInResponse = includeExceptionInResponse;
        return this;
    }

    public Duration getGracePeriod() {
        return this.gracePeriod;
    }

    @Config(value="shutdown.grace-period")
    public ServerConfig setGracePeriod(Duration gracePeriod) {
        this.gracePeriod = gracePeriod;
        return this;
    }

    public boolean isEnhancedErrorReporting() {
        return this.enhancedErrorReporting;
    }

    @Config(value="sql.parser.enhanced-error-reporting")
    public ServerConfig setEnhancedErrorReporting(boolean value) {
        this.enhancedErrorReporting = value;
        return this;
    }

    public boolean isQueryResultsCompressionEnabled() {
        return this.queryResultsCompressionEnabled;
    }

    @Config(value="query-results.compression-enabled")
    public ServerConfig setQueryResultsCompressionEnabled(boolean queryResultsCompressionEnabled) {
        this.queryResultsCompressionEnabled = queryResultsCompressionEnabled;
        return this;
    }
}

