/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.server.ShutdownAction;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public class GracefulShutdownHandler {
    private static final Logger log = Logger.get(GracefulShutdownHandler.class);
    private static final Duration LIFECYCLE_STOP_TIMEOUT = new Duration(30.0, TimeUnit.SECONDS);
    private final ScheduledExecutorService shutdownHandler = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"shutdown-handler-%s"));
    private final ExecutorService lifeCycleStopper = Executors.newSingleThreadExecutor(Threads.threadsNamed((String)"lifecycle-stopper-%s"));
    private final LifeCycleManager lifeCycleManager;
    private final QueryManager queryManager;
    private final TaskManager sqlTaskManager;
    private final boolean isCoordinator;
    private final ShutdownAction shutdownAction;
    private final Duration gracePeriod;
    @GuardedBy(value="this")
    private boolean shutdownRequested;

    @Inject
    public GracefulShutdownHandler(TaskManager sqlTaskManager, ServerConfig serverConfig, ShutdownAction shutdownAction, LifeCycleManager lifeCycleManager, QueryManager queryManager) {
        this.sqlTaskManager = Objects.requireNonNull(sqlTaskManager, "sqlTaskManager is null");
        this.shutdownAction = Objects.requireNonNull(shutdownAction, "shutdownAction is null");
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.isCoordinator = Objects.requireNonNull(serverConfig, "serverConfig is null").isCoordinator();
        this.gracePeriod = serverConfig.getGracePeriod();
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
    }

    public synchronized void requestShutdown() {
        log.info("Shutdown requested");
        if (this.isShutdownRequested()) {
            return;
        }
        this.setShutdownRequested(true);
        this.shutdownHandler.schedule(() -> {
            if (this.isCoordinator) {
                this.waitForQueriesToComplete();
            } else {
                this.waitForTasksToComplete();
                Uninterruptibles.sleepUninterruptibly((long)this.gracePeriod.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            Future<Object> shutdownFuture = this.lifeCycleStopper.submit(() -> {
                this.lifeCycleManager.stop();
                return null;
            });
            try {
                shutdownFuture.get(LIFECYCLE_STOP_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                log.warn((Throwable)e, "Timed out waiting for the life cycle to stop");
            }
            catch (InterruptedException e) {
                log.warn((Throwable)e, "Interrupted while waiting for the life cycle to stop");
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.warn((Throwable)e, "Problem stopping the life cycle");
            }
            this.shutdownAction.onShutdown();
        }, this.gracePeriod.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void waitForTasksToComplete() {
        List<TaskInfo> activeTasks = this.getActiveTasks();
        while (activeTasks.size() > 0) {
            CountDownLatch countDownLatch = new CountDownLatch(activeTasks.size());
            for (TaskInfo taskInfo : activeTasks) {
                this.sqlTaskManager.addStateChangeListener(taskInfo.getTaskId(), newState -> {
                    if (newState.isDone()) {
                        countDownLatch.countDown();
                    }
                });
            }
            log.info("Waiting for all tasks to finish");
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for all tasks to finish");
                Thread.currentThread().interrupt();
            }
            activeTasks = this.getActiveTasks();
        }
    }

    private List<TaskInfo> getActiveTasks() {
        return (List)this.sqlTaskManager.getAllTaskInfo().stream().filter(taskInfo -> !taskInfo.getTaskStatus().getState().isDone()).collect(ImmutableList.toImmutableList());
    }

    private void waitForQueriesToComplete() {
        List<BasicQueryInfo> activeQueries = this.getActiveQueryInfo();
        while (activeQueries.size() > 0) {
            CountDownLatch countDownLatch = new CountDownLatch(activeQueries.size());
            for (BasicQueryInfo queryInfo : activeQueries) {
                this.queryManager.addStateChangeListener(queryInfo.getQueryId(), newState -> {
                    if (newState.isDone()) {
                        countDownLatch.countDown();
                    }
                });
            }
            log.info("Waiting for all queries to finish");
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for all queries to finish");
                Thread.currentThread().interrupt();
            }
            activeQueries = this.getActiveQueryInfo();
        }
    }

    private List<BasicQueryInfo> getActiveQueryInfo() {
        return (List)this.queryManager.getQueries().stream().filter(queryInfo -> !queryInfo.getState().isDone()).collect(ImmutableList.toImmutableList());
    }

    private synchronized void setShutdownRequested(boolean shutdownRequested) {
        this.shutdownRequested = shutdownRequested;
    }

    public synchronized boolean isShutdownRequested() {
        return this.shutdownRequested;
    }
}

