/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;

public class ResourceManagerConfig {
    private Duration queryExpirationTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration completedQueryExpirationTimeout = new Duration(10.0, TimeUnit.MINUTES);
    private int maxCompletedQueries = 100;
    private Duration nodeStatusTimeout = new Duration(30.0, TimeUnit.SECONDS);
    private Duration memoryPoolInfoRefreshDuration = new Duration(1.0, TimeUnit.SECONDS);
    private Duration queryHeartbeatInterval = new Duration(1.0, TimeUnit.SECONDS);
    private Duration nodeHeartbeatInterval = new Duration(1.0, TimeUnit.SECONDS);
    private int heartbeatThreads = 3;
    private int heartbeatConcurrency = 3;
    private int resourceManagerExecutorThreads = 1000;
    private Duration proxyAsyncTimeout = new Duration(60.0, TimeUnit.SECONDS);

    @MinDuration(value="1ms")
    public Duration getQueryExpirationTimeout() {
        return this.queryExpirationTimeout;
    }

    @Config(value="resource-manager.query-expiration-timeout")
    public ResourceManagerConfig setQueryExpirationTimeout(Duration queryExpirationTimeout) {
        this.queryExpirationTimeout = queryExpirationTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getCompletedQueryExpirationTimeout() {
        return this.completedQueryExpirationTimeout;
    }

    @Config(value="resource-manager.completed-query-expiration-timeout")
    public ResourceManagerConfig setCompletedQueryExpirationTimeout(Duration completedQueryExpirationTimeout) {
        this.completedQueryExpirationTimeout = completedQueryExpirationTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxCompletedQueries() {
        return this.maxCompletedQueries;
    }

    @Config(value="resource-manager.max-completed-queries")
    public ResourceManagerConfig setMaxCompletedQueries(int maxCompletedQueries) {
        this.maxCompletedQueries = maxCompletedQueries;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getNodeStatusTimeout() {
        return this.nodeStatusTimeout;
    }

    @Config(value="resource-manager.node-status-timeout")
    public ResourceManagerConfig setNodeStatusTimeout(Duration nodeStatusTimeout) {
        this.nodeStatusTimeout = nodeStatusTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getMemoryPoolInfoRefreshDuration() {
        return this.memoryPoolInfoRefreshDuration;
    }

    @Config(value="resource-manager.memory-pool-info-refresh-duration")
    public ResourceManagerConfig setMemoryPoolInfoRefreshDuration(Duration memoryPoolInfoRefreshDuration) {
        this.memoryPoolInfoRefreshDuration = memoryPoolInfoRefreshDuration;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getQueryHeartbeatInterval() {
        return this.queryHeartbeatInterval;
    }

    @Config(value="resource-manager.query-heartbeat-interval")
    public ResourceManagerConfig setQueryHeartbeatInterval(Duration queryHeartbeatInterval) {
        this.queryHeartbeatInterval = queryHeartbeatInterval;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getNodeHeartbeatInterval() {
        return this.nodeHeartbeatInterval;
    }

    @Config(value="resource-manager.node-heartbeat-interval")
    public ResourceManagerConfig setNodeHeartbeatInterval(Duration nodeHeartbeatInterval) {
        this.nodeHeartbeatInterval = nodeHeartbeatInterval;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getHeartbeatThreads() {
        return this.heartbeatThreads;
    }

    @Config(value="resource-manager.heartbeat-threads")
    @ConfigDescription(value="Total number of timeout threads across all timeout thread pools")
    public ResourceManagerConfig setHeartbeatThreads(int heartbeatThreads) {
        this.heartbeatThreads = heartbeatThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getHeartbeatConcurrency() {
        return this.heartbeatConcurrency;
    }

    @Config(value="resource-manager.heartbeat-concurrency")
    @ConfigDescription(value="Number of thread pools to handle timeouts. Threads per pool is calculated by http-timeout-threads / http-timeout-concurrency")
    public ResourceManagerConfig setHeartbeatConcurrency(int heartbeatConcurrency) {
        this.heartbeatConcurrency = heartbeatConcurrency;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getResourceManagerExecutorThreads() {
        return this.resourceManagerExecutorThreads;
    }

    @Config(value="resource-manager.executor-threads")
    public ResourceManagerConfig setResourceManagerExecutorThreads(int resourceManagerExecutorThreads) {
        this.resourceManagerExecutorThreads = resourceManagerExecutorThreads;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getProxyAsyncTimeout() {
        return this.proxyAsyncTimeout;
    }

    @Config(value="resource-manager.proxy-async-timeout")
    public ResourceManagerConfig setProxyAsyncTimeout(Duration proxyAsyncTimeout) {
        this.proxyAsyncTimeout = proxyAsyncTimeout;
        return this;
    }
}

