/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.resourceGroups.ResourceGroupRuntimeInfo;
import com.facebook.presto.memory.ClusterMemoryPool;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ForResourceManager;
import com.facebook.presto.resourcemanager.ResourceManagerConfig;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.NodeStatus;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.ClusterMemoryPoolInfo;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public class ResourceManagerClusterStateProvider {
    private final Map<String, CoordinatorQueriesState> nodeQueryStates = new ConcurrentHashMap<String, CoordinatorQueriesState>();
    private final Map<String, InternalNodeState> nodeStatuses = new ConcurrentHashMap<String, InternalNodeState>();
    private final InternalNodeManager internalNodeManager;
    private final int maxCompletedQueries;
    private final Duration queryExpirationTimeout;
    private final Duration completedQueryExpirationTimeout;
    private final boolean isReservedPoolEnabled;
    private final Supplier<Map<MemoryPoolId, ClusterMemoryPoolInfo>> clusterMemoryPoolInfosSupplier;

    @Inject
    public ResourceManagerClusterStateProvider(InternalNodeManager internalNodeManager, ResourceManagerConfig resourceManagerConfig, NodeMemoryConfig nodeMemoryConfig, @ForResourceManager ScheduledExecutorService scheduledExecutorService) {
        this(Objects.requireNonNull(internalNodeManager, "internalNodeManager is null"), Objects.requireNonNull(resourceManagerConfig, "resourceManagerConfig is null").getMaxCompletedQueries(), resourceManagerConfig.getQueryExpirationTimeout(), resourceManagerConfig.getCompletedQueryExpirationTimeout(), resourceManagerConfig.getNodeStatusTimeout(), resourceManagerConfig.getMemoryPoolInfoRefreshDuration(), Objects.requireNonNull(nodeMemoryConfig, "nodeMemoryConfig is null").isReservedPoolEnabled(), Objects.requireNonNull(scheduledExecutorService, "scheduledExecutorService is null"));
    }

    public ResourceManagerClusterStateProvider(InternalNodeManager internalNodeManager, int maxCompletedQueries, Duration queryExpirationTimeout, Duration completedQueryExpirationTimeout, Duration nodeStatusTimeout, Duration memoryPoolInfoRefreshDuration, boolean isReservedPoolEnabled, ScheduledExecutorService scheduledExecutorService) {
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        Preconditions.checkArgument((maxCompletedQueries > 0 ? 1 : 0) != 0, (String)"maxCompletedQueries must be > 0, was %s", (int)maxCompletedQueries);
        this.maxCompletedQueries = maxCompletedQueries;
        this.queryExpirationTimeout = Objects.requireNonNull(queryExpirationTimeout, "queryExpirationTimeout is null");
        this.completedQueryExpirationTimeout = Objects.requireNonNull(completedQueryExpirationTimeout, "completedQueryExpirationTimeout is null");
        Objects.requireNonNull(memoryPoolInfoRefreshDuration, "memoryPoolInfoRefreshDuration is null");
        this.clusterMemoryPoolInfosSupplier = memoryPoolInfoRefreshDuration.toMillis() > 0L ? Suppliers.memoizeWithExpiration(this::getClusterMemoryPoolInfoInternal, (long)memoryPoolInfoRefreshDuration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : this::getClusterMemoryPoolInfoInternal;
        this.isReservedPoolEnabled = isReservedPoolEnabled;
        Objects.requireNonNull(scheduledExecutorService, "scheduledExecutorService is null");
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            for (CoordinatorQueriesState coordinatorQueriesState : ImmutableList.copyOf(this.nodeQueryStates.values())) {
                coordinatorQueriesState.purgeExpiredQueries();
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            for (Map.Entry nodeEntry : ImmutableList.copyOf(this.nodeStatuses.entrySet())) {
                if (System.currentTimeMillis() - ((InternalNodeState)nodeEntry.getValue()).getLastHeartbeatInMillis() <= nodeStatusTimeout.toMillis()) continue;
                this.nodeStatuses.remove(nodeEntry.getKey());
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public void registerQueryHeartbeat(String nodeId, BasicQueryInfo basicQueryInfo) {
        Objects.requireNonNull(nodeId, "nodeId is null");
        Objects.requireNonNull(basicQueryInfo, "basicQueryInfo is null");
        Preconditions.checkArgument((boolean)this.internalNodeManager.getCoordinators().stream().anyMatch(i -> nodeId.equals(i.getNodeIdentifier())), (String)"%s is not a coordinator", (Object)nodeId);
        CoordinatorQueriesState state = this.nodeQueryStates.computeIfAbsent(nodeId, identifier -> new CoordinatorQueriesState(nodeId, this.maxCompletedQueries, this.queryExpirationTimeout.toMillis(), this.completedQueryExpirationTimeout.toMillis()));
        state.addOrUpdateQuery(basicQueryInfo);
    }

    public void registerNodeHeartbeat(NodeStatus nodeStatus) {
        Objects.requireNonNull(nodeStatus, "nodeStatus is null");
        InternalNodeState nodeState = this.nodeStatuses.get(nodeStatus.getNodeId());
        if (nodeState == null) {
            this.nodeStatuses.put(nodeStatus.getNodeId(), new InternalNodeState(nodeStatus));
        } else {
            nodeState.updateNodeStatus(nodeStatus);
        }
    }

    public List<ResourceGroupRuntimeInfo> getClusterResourceGroups(String excludingNode) {
        Objects.requireNonNull(excludingNode, "excludingNode is null");
        HashMap resourceGroupBuilders = new HashMap();
        this.nodeQueryStates.values().stream().filter(state -> !state.getNodeId().equals(excludingNode)).map(CoordinatorQueriesState::getActiveQueries).flatMap(Collection::stream).map(Query::getBasicQueryInfo).filter(info -> info.getResourceGroupId().isPresent()).forEach(info -> {
            ResourceGroupId resourceGroupId = info.getResourceGroupId().get();
            ResourceGroupRuntimeInfo.Builder builder = resourceGroupBuilders.computeIfAbsent(resourceGroupId, ResourceGroupRuntimeInfo::builder);
            if (info.getState() == QueryState.QUEUED) {
                builder.addQueuedQueries(1);
            } else if (!info.getState().isDone()) {
                builder.addRunningQueries(1);
            }
            builder.addUserMemoryReservationBytes(info.getQueryStats().getUserMemoryReservation().toBytes());
        });
        return (List)resourceGroupBuilders.values().stream().map(ResourceGroupRuntimeInfo.Builder::build).collect(ImmutableList.toImmutableList());
    }

    public List<BasicQueryInfo> getClusterQueries() {
        return (List)ImmutableList.copyOf(this.nodeQueryStates.values()).stream().map(CoordinatorQueriesState::getAllQueries).flatMap(Collection::stream).map(Query::getBasicQueryInfo).collect(ImmutableList.toImmutableList());
    }

    public Map<MemoryPoolId, ClusterMemoryPoolInfo> getClusterMemoryPoolInfo() {
        return this.clusterMemoryPoolInfosSupplier.get();
    }

    private Map<MemoryPoolId, ClusterMemoryPoolInfo> getClusterMemoryPoolInfoInternal() {
        List memoryInfos = (List)this.nodeStatuses.values().stream().map(nodeStatus -> nodeStatus.getNodeStatus().getMemoryInfo()).collect(ImmutableList.toImmutableList());
        Map<MemoryPoolId, Long> counts = this.nodeQueryStates.values().stream().map(CoordinatorQueriesState::getActiveQueries).flatMap(Collection::stream).collect(Collectors.groupingBy(query -> query.getBasicQueryInfo().getMemoryPool(), Collectors.counting()));
        counts.putIfAbsent(LocalMemoryManager.GENERAL_POOL, 0L);
        if (this.isReservedPoolEnabled) {
            counts.putIfAbsent(LocalMemoryManager.RESERVED_POOL, 0L);
        }
        return (Map)counts.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            ClusterMemoryPool pool = new ClusterMemoryPool((MemoryPoolId)entry.getKey());
            pool.update(memoryInfos, Math.toIntExact((Long)entry.getValue()));
            return pool.getClusterInfo();
        }));
    }

    public Map<String, MemoryInfo> getWorkerMemoryInfo() {
        return (Map)this.nodeStatuses.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> {
            String nodeIdentifier = ((InternalNodeState)e.getValue()).getNodeStatus().getNodeId();
            String nodeHost = URI.create(((InternalNodeState)e.getValue()).getNodeStatus().getExternalAddress()).getHost();
            return nodeIdentifier + " [" + nodeHost + "]";
        }, e -> ((InternalNodeState)e.getValue()).getNodeStatus().getMemoryInfo()));
    }

    private static boolean isQueryExpired(Query query, long timeoutInMillis, long timeout) {
        return timeoutInMillis - query.getLastHeartbeatInMillis() > timeout;
    }

    private static boolean isQueryCompleted(Query query) {
        return query.getBasicQueryInfo().getState().isDone();
    }

    public static class Query {
        private final QueryId queryId;
        private volatile BasicQueryInfo basicQueryInfo;
        private final AtomicLong lastHeartbeatInMillis = new AtomicLong();

        public Query(BasicQueryInfo basicQueryInfo) {
            this.queryId = basicQueryInfo.getQueryId();
            this.basicQueryInfo = basicQueryInfo;
            this.recordHeartbeat();
        }

        private void recordHeartbeat() {
            this.lastHeartbeatInMillis.set(System.currentTimeMillis());
        }

        public long getLastHeartbeatInMillis() {
            return this.lastHeartbeatInMillis.get();
        }

        public Query updateQueryInfo(BasicQueryInfo basicQueryInfo) {
            Objects.requireNonNull(basicQueryInfo, "basicQueryInfo is null");
            if (basicQueryInfo.getState().getValue() >= this.basicQueryInfo.getState().getValue()) {
                this.basicQueryInfo = basicQueryInfo;
            }
            this.recordHeartbeat();
            return this;
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public BasicQueryInfo getBasicQueryInfo() {
            return this.basicQueryInfo;
        }
    }

    private static final class InternalNodeState {
        private volatile NodeStatus nodeStatus;
        private final AtomicLong lastHeartbeatInMillis = new AtomicLong();

        private InternalNodeState(NodeStatus nodeStatus) {
            this.nodeStatus = nodeStatus;
            this.recordHeartbeat();
        }

        private void recordHeartbeat() {
            this.lastHeartbeatInMillis.set(System.currentTimeMillis());
        }

        public long getLastHeartbeatInMillis() {
            return this.lastHeartbeatInMillis.get();
        }

        public InternalNodeState updateNodeStatus(NodeStatus nodeStatus) {
            Objects.requireNonNull(nodeStatus, "nodeStatus is null");
            this.nodeStatus = nodeStatus;
            this.recordHeartbeat();
            return this;
        }

        public NodeStatus getNodeStatus() {
            return this.nodeStatus;
        }
    }

    private static class CoordinatorQueriesState {
        private final String nodeId;
        private final int maxCompletedQueries;
        private final long queryExpirationTimeoutMillis;
        private final long completedQueryExpirationTimeoutMillis;
        @GuardedBy(value="this")
        private final Map<QueryId, Query> activeQueries = new HashMap<QueryId, Query>();
        @GuardedBy(value="this")
        private final Map<QueryId, Query> completedQueries = new LinkedHashMap<QueryId, Query>();

        public CoordinatorQueriesState(String nodeId, int maxCompletedQueries, long queryExpirationTimeoutMillis, long completedQueryExpirationTimeoutMillis) {
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
            Preconditions.checkArgument((maxCompletedQueries > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((queryExpirationTimeoutMillis > 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((completedQueryExpirationTimeoutMillis > 0L ? 1 : 0) != 0);
            this.maxCompletedQueries = maxCompletedQueries;
            this.queryExpirationTimeoutMillis = queryExpirationTimeoutMillis;
            this.completedQueryExpirationTimeoutMillis = completedQueryExpirationTimeoutMillis;
        }

        public synchronized void addOrUpdateQuery(BasicQueryInfo basicQueryInfo) {
            Objects.requireNonNull(basicQueryInfo, "basicQueryInfo is null");
            QueryId queryId = basicQueryInfo.getQueryId();
            Query query = this.activeQueries.get(queryId);
            if (query == null) {
                query = new Query(basicQueryInfo);
                this.activeQueries.put(queryId, query);
            } else {
                query = query.updateQueryInfo(basicQueryInfo);
            }
            if (ResourceManagerClusterStateProvider.isQueryCompleted(query)) {
                this.completedQueries.put(query.getQueryId(), query);
                this.activeQueries.remove(query.getQueryId());
            }
        }

        public synchronized void purgeExpiredQueries() {
            long currentTimeMillis = System.currentTimeMillis();
            Iterator<Query> queryIterator = this.activeQueries.values().iterator();
            while (queryIterator.hasNext()) {
                Query query = queryIterator.next();
                if (!ResourceManagerClusterStateProvider.isQueryExpired(query, currentTimeMillis, this.queryExpirationTimeoutMillis)) continue;
                this.completedQueries.put(query.getQueryId(), query);
                queryIterator.remove();
            }
            Iterator<Query> completedQueriesIterator = this.completedQueries.values().iterator();
            while (completedQueriesIterator.hasNext()) {
                Query query = completedQueriesIterator.next();
                if (this.completedQueries.size() <= this.maxCompletedQueries && !ResourceManagerClusterStateProvider.isQueryExpired(query, currentTimeMillis, this.completedQueryExpirationTimeoutMillis)) break;
                completedQueriesIterator.remove();
            }
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public synchronized List<Query> getActiveQueries() {
            return ImmutableList.copyOf(this.activeQueries.values());
        }

        public synchronized List<Query> getAllQueries() {
            this.purgeExpiredQueries();
            return ImmutableList.builder().addAll(this.activeQueries.values()).addAll(this.completedQueries.values()).build();
        }
    }
}

