/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class FrameInfo {
    private final WindowNode.Frame.WindowType type;
    private final WindowNode.Frame.BoundType startType;
    private final int startChannel;
    private final WindowNode.Frame.BoundType endType;
    private final int endChannel;

    public FrameInfo(WindowNode.Frame.WindowType type, WindowNode.Frame.BoundType startType, Optional<Integer> startChannel, WindowNode.Frame.BoundType endType, Optional<Integer> endChannel) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.startType = Objects.requireNonNull(startType, "startType is null");
        this.startChannel = Objects.requireNonNull(startChannel, "startChannel is null").orElse(-1);
        this.endType = Objects.requireNonNull(endType, "endType is null");
        this.endChannel = Objects.requireNonNull(endChannel, "endChannel is null").orElse(-1);
    }

    public WindowNode.Frame.WindowType getType() {
        return this.type;
    }

    public WindowNode.Frame.BoundType getStartType() {
        return this.startType;
    }

    public int getStartChannel() {
        return this.startChannel;
    }

    public WindowNode.Frame.BoundType getEndType() {
        return this.endType;
    }

    public int getEndChannel() {
        return this.endChannel;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.startType, this.startChannel, this.endType, this.endChannel});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FrameInfo other = (FrameInfo)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.startType, (Object)other.startType) && Objects.equals(this.startChannel, other.startChannel) && Objects.equals((Object)this.endType, (Object)other.endType) && Objects.equals(this.endChannel, other.endChannel);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("startType", (Object)this.startType).add("startChannel", this.startChannel).add("endType", (Object)this.endType).add("endChannel", this.endChannel).toString();
    }
}

