/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.annotations;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.operator.annotations.FunctionsParserHelper;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.function.SqlInvokedScalarFunction;
import com.facebook.presto.spi.function.SqlParameter;
import com.facebook.presto.spi.function.SqlParameters;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public final class SqlInvokedScalarFromAnnotationsParser {
    private SqlInvokedScalarFromAnnotationsParser() {
    }

    public static List<SqlInvokedFunction> parseFunctionDefinition(Class<?> clazz) {
        Preconditions.checkArgument((boolean)clazz.isAnnotationPresent(SqlInvokedScalarFunction.class), (String)"Class is not annotated with SqlInvokedScalarFunction: %s", (Object)clazz.getName());
        SqlInvokedScalarFunction header = clazz.getAnnotation(SqlInvokedScalarFunction.class);
        Optional<String> description = Optional.ofNullable(clazz.getAnnotation(Description.class)).map(Description::value);
        return (List)SqlInvokedScalarFromAnnotationsParser.findScalarsInFunctionDefinitionClass(clazz).stream().map(method -> SqlInvokedScalarFromAnnotationsParser.createSqlInvokedFunctions(method, Optional.of(header), description)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    public static List<SqlInvokedFunction> parseFunctionDefinitions(Class<?> clazz) {
        return (List)SqlInvokedScalarFromAnnotationsParser.findScalarsInFunctionSetClass(clazz).stream().map(method -> SqlInvokedScalarFromAnnotationsParser.createSqlInvokedFunctions(method, Optional.empty(), Optional.empty())).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private static List<Method> findScalarsInFunctionDefinitionClass(Class<?> clazz) {
        Set<Method> methods = FunctionsParserHelper.findPublicStaticMethods(clazz, (Set<Class<? extends Annotation>>)ImmutableSet.of(SqlInvokedScalarFunction.class, SqlType.class, SqlParameter.class, SqlParameters.class, Description.class), (Set<Class<? extends Annotation>>)ImmutableSet.of(ScalarFunction.class, ScalarOperator.class));
        for (Method method : methods) {
            Failures.checkCondition(!method.isAnnotationPresent(SqlInvokedScalarFunction.class) && !method.isAnnotationPresent(Description.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Function-defining method [%s] cannot have @SqlInvokedScalarFunction", method);
            Failures.checkCondition(method.isAnnotationPresent(SqlType.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Function-defining method [%s] is missing @SqlType", method);
            SqlInvokedScalarFromAnnotationsParser.checkReturnString(method);
        }
        return ImmutableList.copyOf(methods);
    }

    private static List<Method> findScalarsInFunctionSetClass(Class<?> clazz) {
        Set<Method> methods = FunctionsParserHelper.findPublicStaticMethods(clazz, (Set<Class<? extends Annotation>>)ImmutableSet.of(SqlInvokedScalarFunction.class, SqlType.class, SqlParameter.class, SqlParameters.class, Description.class), (Set<Class<? extends Annotation>>)ImmutableSet.of(ScalarFunction.class, ScalarOperator.class));
        for (Method method : methods) {
            Failures.checkCondition(method.isAnnotationPresent(SqlInvokedScalarFunction.class) && method.isAnnotationPresent(SqlType.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Function-defining method [%s] is missing @SqlInvokedScalarFunction or @SqlType", method);
            SqlInvokedScalarFromAnnotationsParser.checkReturnString(method);
        }
        return ImmutableList.copyOf(methods);
    }

    private static List<SqlInvokedFunction> createSqlInvokedFunctions(Method method, Optional<SqlInvokedScalarFunction> header, Optional<String> description) {
        String body;
        SqlInvokedScalarFunction functionHeader = header.orElse(method.getAnnotation(SqlInvokedScalarFunction.class));
        String functionDescription = description.orElse(method.isAnnotationPresent(Description.class) ? method.getAnnotation(Description.class).value() : "");
        TypeSignature returnType = TypeSignature.parseTypeSignature((String)method.getAnnotation(SqlType.class).value());
        Failures.checkCondition(!method.isAnnotationPresent(SqlParameter.class) || !method.isAnnotationPresent(SqlParameters.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Function-defining method [%s] is annotated with both @SqlParameter and @SqlParameters", method);
        Object parameters = method.isAnnotationPresent(SqlParameter.class) ? ImmutableList.of((Object)SqlInvokedScalarFromAnnotationsParser.getParameterFromAnnotation(method.getAnnotation(SqlParameter.class))) : (method.isAnnotationPresent(SqlParameters.class) ? (List)Arrays.stream(method.getAnnotation(SqlParameters.class).value()).map(SqlInvokedScalarFromAnnotationsParser::getParameterFromAnnotation).collect(ImmutableList.toImmutableList()) : ImmutableList.of());
        RoutineCharacteristics routineCharacteristics = RoutineCharacteristics.builder().setLanguage(RoutineCharacteristics.Language.SQL).setDeterminism(functionHeader.deterministic() ? RoutineCharacteristics.Determinism.DETERMINISTIC : RoutineCharacteristics.Determinism.NOT_DETERMINISTIC).setNullCallClause(functionHeader.calledOnNullInput() ? RoutineCharacteristics.NullCallClause.CALLED_ON_NULL_INPUT : RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build();
        try {
            body = (String)method.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Failed to get function body for method [%s]", method), (Throwable)e);
        }
        return (List)Stream.concat(Stream.of(functionHeader.value()), Arrays.stream(functionHeader.alias())).map(arg_0 -> SqlInvokedScalarFromAnnotationsParser.lambda$createSqlInvokedFunctions$2((List)parameters, returnType, functionDescription, routineCharacteristics, body, arg_0)).collect(ImmutableList.toImmutableList());
    }

    private static Parameter getParameterFromAnnotation(SqlParameter sqlParameter) {
        return new Parameter(sqlParameter.name(), TypeSignature.parseTypeSignature((String)sqlParameter.type()));
    }

    private static void checkReturnString(Method method) {
        Failures.checkCondition(method.getReturnType().equals(String.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Function-defining method [%s] must return String", new Object[0]);
    }

    private static /* synthetic */ SqlInvokedFunction lambda$createSqlInvokedFunctions$2(List parameters, TypeSignature returnType, String functionDescription, RoutineCharacteristics routineCharacteristics, String body, String name) {
        return new SqlInvokedFunction(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)name), parameters, returnType, functionDescription, routineCharacteristics, body, FunctionVersion.notVersioned());
    }
}

