/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.InvokeFunctionBytecodeExpression;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class RowIndeterminateOperator
extends SqlOperator {
    public static final RowIndeterminateOperator ROW_INDETERMINATE = new RowIndeterminateOperator();

    private RowIndeterminateOperator() {
        super(OperatorType.INDETERMINATE, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.withVariadicBound((String)"T", (String)"row")), (List<LongVariableConstraint>)ImmutableList.of(), BooleanType.BOOLEAN.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T")));
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type type = boundVariables.getTypeVariable("T");
        Class<?> indeterminateOperatorClass = RowIndeterminateOperator.generateIndeterminate(type, functionAndTypeManager);
        MethodHandle indeterminateMethod = Reflection.methodHandle(indeterminateOperatorClass, "indeterminate", type.getJavaType(), Boolean.TYPE);
        return new BuiltInScalarFunctionImplementation(false, (List<BuiltInScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.USE_NULL_FLAG)), indeterminateMethod);
    }

    private static Class<?> generateIndeterminate(Type type, FunctionAndTypeManager functionAndTypeManager) {
        CallSiteBinder binder = new CallSiteBinder();
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("RowIndeterminateOperator"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        Parameter value = Parameter.arg((String)"value", (Class)type.getJavaType());
        Parameter isNull = Parameter.arg((String)"isNull", Boolean.TYPE);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "indeterminate", ParameterizedType.type(Boolean.TYPE), new Parameter[]{value, isNull});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        body.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(definition, binder);
        LabelNode end = new LabelNode("end");
        List fieldTypes = type.getTypeParameters();
        boolean hasUnknownFields = fieldTypes.stream().anyMatch(fieldType -> fieldType.equals(UnknownType.UNKNOWN));
        body.append((BytecodeNode)new IfStatement("if isNull is true...", new Object[0]).condition((BytecodeNode)isNull).ifTrue((BytecodeNode)new BytecodeBlock().push(true).gotoLabel(end)));
        if (hasUnknownFields) {
            body.push(true).gotoLabel(end);
        } else {
            for (int i = 0; i < fieldTypes.size(); ++i) {
                IfStatement ifNullField = new IfStatement("if the field is null...", new Object[0]);
                ifNullField.condition((BytecodeNode)value.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)})).ifTrue((BytecodeNode)new BytecodeBlock().push(true).gotoLabel(end));
                FunctionHandle functionHandle = functionAndTypeManager.resolveOperator(OperatorType.INDETERMINATE, TypeSignatureProvider.fromTypes((Type)fieldTypes.get(i)));
                BuiltInScalarFunctionImplementation function = functionAndTypeManager.getBuiltInScalarFunctionImplementation(functionHandle);
                BytecodeExpression element = SqlTypeBytecodeExpression.constantType(binder, (Type)fieldTypes.get(i)).getValue((BytecodeExpression)value, BytecodeExpressions.constantInt((int)i));
                ifNullField.ifFalse((BytecodeNode)new IfStatement("if the field is not null but indeterminate...", new Object[0]).condition((BytecodeNode)InvokeFunctionBytecodeExpression.invokeFunction(scope, cachedInstanceBinder, functionAndTypeManager.getFunctionMetadata(functionHandle).getName().getObjectName(), function, element)).ifTrue((BytecodeNode)new BytecodeBlock().push(true).gotoLabel(end)));
                body.append((BytecodeNode)ifNullField);
            }
            body.push(false);
        }
        body.visitLabel(end).retBoolean();
        MethodDefinition constructorDefinition = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), RowIndeterminateOperator.class.getClassLoader());
    }
}

