/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.sql.gen.lambda.UnaryFunctionInterface;
import com.google.common.collect.ImmutableList;
import io.airlift.joni.Matcher;
import io.airlift.joni.Regex;
import io.airlift.joni.Region;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import java.util.List;

@ScalarFunction(value="regexp_replace")
@Description(value="replaces substrings matching a regular expression using a lambda function")
public final class JoniRegexpReplaceLambdaFunction {
    private final PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)VarcharType.VARCHAR));

    @LiteralParameters(value={"x"})
    @SqlType(value="varchar")
    @SqlNullable
    public Slice regexpReplace(@SqlType(value="varchar") Slice source, @SqlType(value="JoniRegExp") Regex pattern, @SqlType(value="function(array(varchar), varchar(x))") UnaryFunctionInterface replaceFunction) {
        Matcher matcher = pattern.matcher(source.getBytes());
        if (matcher.search(0, source.length(), 0) == -1) {
            return source;
        }
        DynamicSliceOutput output = new DynamicSliceOutput(source.length());
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        int groupCount = pattern.numberOfCaptures();
        int appendPosition = 0;
        int nextStart = 0;
        do {
            nextStart = matcher.getEnd() == matcher.getBegin() ? matcher.getEnd() + 1 : matcher.getEnd();
            Slice unmatched = source.slice(appendPosition, matcher.getBegin() - appendPosition);
            appendPosition = matcher.getEnd();
            output.appendBytes(unmatched);
            Region matchedRegion = matcher.getEagerRegion();
            for (int i = 1; i <= groupCount; ++i) {
                if (matchedRegion.beg[i] >= 0 && matchedRegion.end[i] >= 0) {
                    VarcharType.VARCHAR.writeSlice(blockBuilder, source, matchedRegion.beg[i], matchedRegion.end[i] - matchedRegion.beg[i]);
                    continue;
                }
                blockBuilder.appendNull();
            }
            this.pageBuilder.declarePositions(groupCount);
            Block target = blockBuilder.getRegion(blockBuilder.getPositionCount() - groupCount, groupCount);
            Slice replaced = (Slice)replaceFunction.apply(target);
            if (replaced == null) {
                return null;
            }
            output.appendBytes(replaced);
        } while (matcher.search(nextStart, source.length(), 0) != -1);
        output.writeBytes(source, appendPosition, source.length() - appendPosition);
        return output.slice();
    }
}

