/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.IpAddressOperators;
import com.facebook.presto.type.IpAddressType;
import com.facebook.presto.type.IpPrefixOperators;
import com.facebook.presto.type.IpPrefixType;
import com.facebook.presto.util.Failures;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IpPrefixFunctions {
    private IpPrefixFunctions() {
    }

    @Description(value="IP prefix for a given IP address and subnet size")
    @ScalarFunction(value="ip_prefix")
    @SqlType(value="ipprefix")
    public static Slice ipPrefix(@SqlType(value="ipaddress") Slice value, @SqlType(value="bigint") long subnetSize) {
        InetAddress address = IpPrefixFunctions.toInetAddress(value);
        int addressLength = address.getAddress().length;
        if (addressLength == 4) {
            Failures.checkCondition(0L <= subnetSize && subnetSize <= 32L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "IPv4 subnet size must be in range [0, 32]", new Object[0]);
        } else if (addressLength == 16) {
            Failures.checkCondition(0L <= subnetSize && subnetSize <= 128L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "IPv6 subnet size must be in range [0, 128]", new Object[0]);
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid InetAddress length: " + addressLength);
        }
        return IpPrefixOperators.castFromVarcharToIpPrefix(Slices.utf8Slice((String)(InetAddresses.toAddrString((InetAddress)address) + "/" + subnetSize)));
    }

    @Description(value="IP prefix for a given IP address and subnet size")
    @ScalarFunction(value="ip_prefix")
    @LiteralParameters(value={"x"})
    @SqlType(value="ipprefix")
    public static Slice stringIpPrefix(@SqlType(value="varchar(x)") Slice slice, @SqlType(value="bigint") long subnetSize) {
        return IpPrefixFunctions.ipPrefix(IpAddressOperators.castFromVarcharToIpAddress(slice), subnetSize);
    }

    @Description(value="Smallest IP address for a given IP prefix")
    @ScalarFunction(value="ip_subnet_min")
    @SqlType(value="ipaddress")
    public static Slice ipSubnetMin(@SqlType(value="ipprefix") Slice value) {
        return IpPrefixOperators.castFromIpPrefixToIpAddress(value);
    }

    @Description(value="Largest IP address for a given IP prefix")
    @ScalarFunction(value="ip_subnet_max")
    @SqlType(value="ipaddress")
    public static Slice ipSubnetMax(@SqlType(value="ipprefix") Slice value) {
        byte[] address = IpPrefixFunctions.toInetAddress(value.slice(0, IpAddressType.IPADDRESS.getFixedSize())).getAddress();
        int subnetSize = value.getByte(IpPrefixType.IPPREFIX.getFixedSize() - 1) & 0xFF;
        if (address.length == 4) {
            for (int i = 0; i < 4; ++i) {
                int n = 3 - i;
                address[n] = (byte)(address[n] | (byte)(~(-1 << Math.min(Math.max(32 - subnetSize - 8 * i, 0), 8))));
            }
            byte[] bytes = new byte[16];
            bytes[10] = -1;
            bytes[11] = -1;
            System.arraycopy(address, 0, bytes, 12, 4);
            address = bytes;
        } else if (address.length == 16) {
            for (int i = 0; i < 16; ++i) {
                int n = 15 - i;
                address[n] = (byte)(address[n] | (byte)(~(-1 << Math.min(Math.max(128 - subnetSize - 8 * i, 0), 8))));
            }
        }
        return Slices.wrappedBuffer((byte[])address);
    }

    @Description(value="Array of smallest and largest IP address in the subnet of the given IP prefix")
    @ScalarFunction(value="ip_subnet_range")
    @SqlType(value="array(IPADDRESS)")
    public static Block ipSubnetRange(@SqlType(value="ipprefix") Slice value) {
        BlockBuilder blockBuilder = IpAddressType.IPADDRESS.createBlockBuilder(null, 2);
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, IpPrefixFunctions.ipSubnetMin(value));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, IpPrefixFunctions.ipSubnetMax(value));
        return blockBuilder.build();
    }

    @Description(value="Is the IP address in the subnet of IP prefix")
    @ScalarFunction(value="is_subnet_of")
    @SqlType(value="boolean")
    public static boolean isSubnetOf(@SqlType(value="ipprefix") Slice ipPrefix, @SqlType(value="ipaddress") Slice ipAddress) {
        IpPrefixFunctions.toInetAddress(ipAddress);
        return IpAddressOperators.between(ipAddress, IpPrefixFunctions.ipSubnetMin(ipPrefix), IpPrefixFunctions.ipSubnetMax(ipPrefix));
    }

    @Description(value="Is the second IP prefix in the subnet of the first IP prefix")
    @ScalarFunction(value="is_subnet_of")
    @SqlType(value="boolean")
    public static boolean isPrefixSubnetOf(@SqlType(value="ipprefix") Slice first, @SqlType(value="ipprefix") Slice second) {
        return IpAddressOperators.between(IpPrefixFunctions.ipSubnetMin(second), IpPrefixFunctions.ipSubnetMin(first), IpPrefixFunctions.ipSubnetMax(first)) && IpAddressOperators.between(IpPrefixFunctions.ipSubnetMax(second), IpPrefixFunctions.ipSubnetMin(first), IpPrefixFunctions.ipSubnetMax(first));
    }

    private static InetAddress toInetAddress(Slice ipAddress) {
        try {
            return InetAddress.getByAddress(ipAddress.getBytes());
        }
        catch (UnknownHostException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid IP address binary: " + ipAddress.toStringUtf8(), (Throwable)e);
        }
    }
}

