/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.operator.UncheckedByteArrays;
import com.facebook.presto.operator.repartition.AbstractBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.BlockEncodingBuffer;
import com.facebook.presto.operator.repartition.DecodedBlockNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import io.airlift.slice.SliceOutput;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public class ArrayBlockEncodingBuffer
extends AbstractBlockEncodingBuffer {
    @VisibleForTesting
    static final int POSITION_SIZE = 5;
    private static final String NAME = "ARRAY";
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayBlockEncodingBuffer.class).instanceSize();
    private byte[] offsetsBuffer;
    private int offsetsBufferIndex;
    private int estimatedOffsetBufferMaxCapacity;
    private int[] offsets;
    private int lastOffset;
    private final AbstractBlockEncodingBuffer valuesBuffers;

    public ArrayBlockEncodingBuffer(DecodedBlockNode decodedBlockNode, ArrayAllocator bufferAllocator, boolean isNested) {
        super(bufferAllocator, isNested);
        this.valuesBuffers = (AbstractBlockEncodingBuffer)ArrayBlockEncodingBuffer.createBlockEncodingBuffers(decodedBlockNode.getChildren().get(0), bufferAllocator, true);
    }

    @Override
    public void accumulateSerializedRowSizes(int[] serializedRowSizes) {
        int i = 0;
        while (i < this.positionCount) {
            int n = i++;
            serializedRowSizes[n] = serializedRowSizes[n] + 5;
        }
        int[] offsetsCopy = Arrays.ensureCapacity(null, (int)(this.positionCount + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
        try {
            System.arraycopy(this.offsets, 0, offsetsCopy, 0, this.positionCount + 1);
            this.valuesBuffers.accumulateSerializedRowSizes(offsetsCopy, this.positionCount, serializedRowSizes);
        }
        finally {
            this.bufferAllocator.returnArray(offsetsCopy);
        }
    }

    @Override
    public void setNextBatch(int positionsOffset, int batchSize) {
        this.positionsOffset = positionsOffset;
        this.batchSize = batchSize;
        this.flushed = false;
        if (this.positionCount == 0) {
            return;
        }
        int offset = this.offsets[positionsOffset];
        this.valuesBuffers.setNextBatch(offset, this.offsets[positionsOffset + batchSize] - offset);
    }

    @Override
    public void appendDataInBatch() {
        if (this.batchSize == 0) {
            return;
        }
        this.appendNulls();
        this.appendOffsets();
        this.valuesBuffers.appendDataInBatch();
        this.bufferedPositionCount += this.batchSize;
    }

    @Override
    public void serializeTo(SliceOutput output) {
        ArrayBlockEncodingBuffer.writeLengthPrefixedString(output, NAME);
        this.valuesBuffers.serializeTo(output);
        output.writeInt(this.bufferedPositionCount);
        output.writeInt(0);
        if (this.offsetsBufferIndex > 0) {
            output.appendBytes(this.offsetsBuffer, 0, this.offsetsBufferIndex);
        }
        this.serializeNullsTo(output);
    }

    @Override
    public void resetBuffers() {
        this.bufferedPositionCount = 0;
        this.offsetsBufferIndex = 0;
        this.lastOffset = 0;
        this.flushed = true;
        this.resetNullsBuffer();
        this.valuesBuffers.resetBuffers();
    }

    @Override
    public void noMoreBatches() {
        this.valuesBuffers.noMoreBatches();
        if (this.flushed && this.offsetsBuffer != null) {
            this.bufferAllocator.returnArray(this.offsetsBuffer);
            this.offsetsBuffer = null;
        }
        super.noMoreBatches();
        if (this.offsets != null) {
            this.bufferAllocator.returnArray(this.offsets);
            this.offsets = null;
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.valuesBuffers.getRetainedSizeInBytes();
    }

    @Override
    public long getSerializedSizeInBytes() {
        return (long)(NAME.length() + 4) + this.valuesBuffers.getSerializedSizeInBytes() + 4L + 4L + (long)this.offsetsBufferIndex + this.getNullsBufferSerializedSizeInBytes();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("estimatedOffsetBufferMaxCapacity", this.estimatedOffsetBufferMaxCapacity).add("offsetsBufferCapacity", this.offsetsBuffer == null ? 0 : this.offsetsBuffer.length).add("offsetsBufferIndex", this.offsetsBufferIndex).add("offsetsCapacity", this.offsets == null ? 0 : this.offsets.length).add("lastOffset", this.lastOffset).add("valueBuffers", (Object)this.valuesBuffers).toString();
    }

    @Override
    int getEstimatedValueBufferMaxCapacity() {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    int getEstimatedOffsetBufferMaxCapacity() {
        return this.estimatedOffsetBufferMaxCapacity;
    }

    @VisibleForTesting
    BlockEncodingBuffer getValuesBuffers() {
        return this.valuesBuffers;
    }

    @Override
    protected void setupDecodedBlockAndMapPositions(DecodedBlockNode decodedBlockNode, int partitionBufferCapacity, double decodedBlockPageSizeFraction) {
        Objects.requireNonNull(decodedBlockNode, "decodedBlockNode is null");
        decodedBlockNode = this.mapPositionsToNestedBlock(decodedBlockNode);
        ColumnarArray columnarArray = (ColumnarArray)decodedBlockNode.getDecodedBlock();
        this.decodedBlock = columnarArray.getNullCheckBlock();
        long estimatedSerializedSizeInBytes = decodedBlockNode.getEstimatedSerializedSizeInBytes();
        long childrenEstimatedSerializedSizeInBytes = decodedBlockNode.getChildren().get(0).getEstimatedSerializedSizeInBytes();
        double targetBufferSize = (double)partitionBufferCapacity * decodedBlockPageSizeFraction * (double)(estimatedSerializedSizeInBytes - childrenEstimatedSerializedSizeInBytes) / (double)estimatedSerializedSizeInBytes;
        this.setEstimatedNullsBufferMaxCapacity(ArrayBlockEncodingBuffer.getEstimatedBufferMaxCapacity(targetBufferSize, 1, 5));
        this.estimatedOffsetBufferMaxCapacity = ArrayBlockEncodingBuffer.getEstimatedBufferMaxCapacity(targetBufferSize, 4, 5);
        this.populateNestedPositions(columnarArray);
        this.valuesBuffers.setupDecodedBlockAndMapPositions(decodedBlockNode.getChildren().get(0), partitionBufferCapacity, decodedBlockPageSizeFraction * (double)childrenEstimatedSerializedSizeInBytes / (double)estimatedSerializedSizeInBytes);
    }

    @Override
    protected void accumulateSerializedRowSizes(int[] positionOffsets, int positionCount, int[] serializedRowSizes) {
        if (this.positionCount == 0) {
            return;
        }
        int lastOffset = positionOffsets[0];
        for (int i = 0; i < positionCount; ++i) {
            int offset = positionOffsets[i + 1];
            int n = i;
            serializedRowSizes[n] = serializedRowSizes[n] + 5 * (offset - lastOffset);
            lastOffset = offset;
            positionOffsets[i + 1] = this.offsets[offset];
        }
        this.valuesBuffers.accumulateSerializedRowSizes(positionOffsets, positionCount, serializedRowSizes);
    }

    private void populateNestedPositions(ColumnarArray columnarArray) {
        int i;
        this.valuesBuffers.resetPositions();
        if (this.positionCount == 0) {
            return;
        }
        this.offsets = Arrays.ensureCapacity((int[])this.offsets, (int)(this.positionCount + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
        this.offsets[0] = 0;
        int[] positions = this.getPositions();
        for (i = 0; i < this.positionCount; ++i) {
            this.offsets[i + 1] = this.offsets[i] + columnarArray.getLength(positions[i]);
        }
        this.valuesBuffers.ensurePositionsCapacity(this.offsets[this.positionCount]);
        for (i = 0; i < this.positionCount; ++i) {
            this.valuesBuffers.appendPositionRange(columnarArray.getOffset(positions[i]), this.offsets[i + 1] - this.offsets[i]);
        }
    }

    private void appendOffsets() {
        this.offsetsBuffer = Arrays.ensureCapacity((byte[])this.offsetsBuffer, (int)(this.offsetsBufferIndex + this.batchSize * Unsafe.ARRAY_INT_INDEX_SCALE), (int)this.estimatedOffsetBufferMaxCapacity, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE, (ArrayAllocator)this.bufferAllocator);
        int baseOffset = this.lastOffset - this.offsets[this.positionsOffset];
        for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
            this.offsetsBufferIndex = UncheckedByteArrays.setIntUnchecked(this.offsetsBuffer, this.offsetsBufferIndex, this.offsets[i + 1] + baseOffset);
        }
        this.lastOffset = this.offsets[this.positionsOffset + this.batchSize] + baseOffset;
    }
}

