/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.state.TriStateBooleanState;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;

@AggregationFunction(value="bool_and", alias={"every"})
public final class BooleanAndAggregation {
    private BooleanAndAggregation() {
    }

    @InputFunction
    public static void booleanAnd(@AggregationState TriStateBooleanState state, @SqlType(value="boolean") boolean value) {
        if (!value) {
            state.setByte((byte)-1);
        } else if (state.getByte() == 0) {
            state.setByte((byte)1);
        }
    }

    @CombineFunction
    public static void combine(@AggregationState TriStateBooleanState state, @AggregationState TriStateBooleanState otherState) {
        if (state.getByte() == 0) {
            state.setByte(otherState.getByte());
            return;
        }
        if (otherState.getByte() == -1) {
            state.setByte((byte)-1);
        }
    }

    @OutputFunction(value="boolean")
    public static void output(@AggregationState TriStateBooleanState state, BlockBuilder out) {
        TriStateBooleanState.write((Type)BooleanType.BOOLEAN, state, out);
    }
}

