/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.PipelineStats;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class TaskStats {
    private final DateTime createTime;
    private final DateTime firstStartTime;
    private final DateTime lastStartTime;
    private final DateTime lastEndTime;
    private final DateTime endTime;
    private final long elapsedTimeInNanos;
    private final long queuedTimeInNanos;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int queuedPartitionedDrivers;
    private final int runningDrivers;
    private final int runningPartitionedDrivers;
    private final int blockedDrivers;
    private final int completedDrivers;
    private final double cumulativeUserMemory;
    private final long userMemoryReservationInBytes;
    private final long revocableMemoryReservationInBytes;
    private final long systemMemoryReservationInBytes;
    private final long peakUserMemoryInBytes;
    private final long peakTotalMemoryInBytes;
    private final long peakNodeTotalMemoryInBytes;
    private final long totalScheduledTimeInNanos;
    private final long totalCpuTimeInNanos;
    private final long totalBlockedTimeInNanos;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final long totalAllocationInBytes;
    private final long rawInputDataSizeInBytes;
    private final long rawInputPositions;
    private final long processedInputDataSizeInBytes;
    private final long processedInputPositions;
    private final long outputDataSizeInBytes;
    private final long outputPositions;
    private final long physicalWrittenDataSizeInBytes;
    private final int fullGcCount;
    private final long fullGcTimeInMillis;
    private final List<PipelineStats> pipelines;

    public TaskStats(DateTime createTime, DateTime endTime) {
        this(createTime, null, null, null, endTime, 0L, 0L, 0, 0, 0, 0, 0, 0, 0, 0.0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, false, (Set<BlockedReason>)ImmutableSet.of(), 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0, 0L, (List<PipelineStats>)ImmutableList.of());
    }

    @JsonCreator
    public TaskStats(@JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="firstStartTime") DateTime firstStartTime, @JsonProperty(value="lastStartTime") DateTime lastStartTime, @JsonProperty(value="lastEndTime") DateTime lastEndTime, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="elapsedTimeInNanos") long elapsedTimeInNanos, @JsonProperty(value="queuedTimeInNanos") long queuedTimeInNanos, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="queuedPartitionedDrivers") int queuedPartitionedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="runningPartitionedDrivers") int runningPartitionedDrivers, @JsonProperty(value="blockedDrivers") int blockedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="cumulativeUserMemory") double cumulativeUserMemory, @JsonProperty(value="userMemoryReservation") long userMemoryReservationInBytes, @JsonProperty(value="revocableMemoryReservationInBytes") long revocableMemoryReservationInBytes, @JsonProperty(value="systemMemoryReservationInBytes") long systemMemoryReservationInBytes, @JsonProperty(value="peakTotalMemoryInBytes") long peakTotalMemoryInBytes, @JsonProperty(value="peakUserMemoryInBytes") long peakUserMemoryInBytes, @JsonProperty(value="peakNodeTotalMemoryInbytes") long peakNodeTotalMemoryInBytes, @JsonProperty(value="totalScheduledTimeInNanos") long totalScheduledTimeInNanos, @JsonProperty(value="totalCpuTimeInNanos") long totalCpuTimeInNanos, @JsonProperty(value="totalBlockedTimeInNanos") long totalBlockedTimeInNanos, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="totalAllocationInBytes") long totalAllocationInBytes, @JsonProperty(value="rawInputDataSizeInBytes") long rawInputDataSizeInBytes, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSizeInBytes") long processedInputDataSizeInBytes, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSizeInBytes") long outputDataSizeInBytes, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSizeInBytes") long physicalWrittenDataSizeInBytes, @JsonProperty(value="fullGcCount") int fullGcCount, @JsonProperty(value="fullGcTimeInMillis") long fullGcTimeInMillis, @JsonProperty(value="pipelines") List<PipelineStats> pipelines) {
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.firstStartTime = firstStartTime;
        this.lastStartTime = lastStartTime;
        this.lastEndTime = lastEndTime;
        this.endTime = endTime;
        this.elapsedTimeInNanos = elapsedTimeInNanos;
        this.queuedTimeInNanos = queuedTimeInNanos;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((queuedPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedPartitionedDrivers is negative");
        this.queuedPartitionedDrivers = queuedPartitionedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((runningPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"runningPartitionedDrivers is negative");
        this.runningPartitionedDrivers = runningPartitionedDrivers;
        Preconditions.checkArgument((blockedDrivers >= 0 ? 1 : 0) != 0, (Object)"blockedDrivers is negative");
        this.blockedDrivers = blockedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.userMemoryReservationInBytes = userMemoryReservationInBytes;
        this.revocableMemoryReservationInBytes = revocableMemoryReservationInBytes;
        this.systemMemoryReservationInBytes = systemMemoryReservationInBytes;
        this.peakTotalMemoryInBytes = peakTotalMemoryInBytes;
        this.peakUserMemoryInBytes = peakUserMemoryInBytes;
        this.peakNodeTotalMemoryInBytes = peakNodeTotalMemoryInBytes;
        this.totalScheduledTimeInNanos = totalScheduledTimeInNanos;
        this.totalCpuTimeInNanos = totalCpuTimeInNanos;
        this.totalBlockedTimeInNanos = totalBlockedTimeInNanos;
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.totalAllocationInBytes = totalAllocationInBytes;
        this.rawInputDataSizeInBytes = rawInputDataSizeInBytes;
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.processedInputDataSizeInBytes = processedInputDataSizeInBytes;
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSizeInBytes = outputDataSizeInBytes;
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSizeInBytes = physicalWrittenDataSizeInBytes;
        Preconditions.checkArgument((fullGcCount >= 0 ? 1 : 0) != 0, (Object)"fullGcCount is negative");
        this.fullGcCount = fullGcCount;
        this.fullGcTimeInMillis = fullGcTimeInMillis;
        this.pipelines = ImmutableList.copyOf((Collection)Objects.requireNonNull(pipelines, "pipelines is null"));
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getFirstStartTime() {
        return this.firstStartTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getLastStartTime() {
        return this.lastStartTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getLastEndTime() {
        return this.lastEndTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    public long getElapsedTimeInNanos() {
        return this.elapsedTimeInNanos;
    }

    @JsonProperty
    public long getQueuedTimeInNanos() {
        return this.queuedTimeInNanos;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getBlockedDrivers() {
        return this.blockedDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    @JsonProperty
    public long getUserMemoryReservationInBytes() {
        return this.userMemoryReservationInBytes;
    }

    @JsonProperty
    public long getRevocableMemoryReservationInBytes() {
        return this.revocableMemoryReservationInBytes;
    }

    @JsonProperty
    public long getSystemMemoryReservationInBytes() {
        return this.systemMemoryReservationInBytes;
    }

    @JsonProperty
    public long getPeakUserMemoryInBytes() {
        return this.peakUserMemoryInBytes;
    }

    @JsonProperty
    public long getPeakTotalMemoryInBytes() {
        return this.peakTotalMemoryInBytes;
    }

    @JsonProperty
    public long getPeakNodeTotalMemoryInBytes() {
        return this.peakNodeTotalMemoryInBytes;
    }

    @JsonProperty
    public long getTotalScheduledTimeInNanos() {
        return this.totalScheduledTimeInNanos;
    }

    @JsonProperty
    public long getTotalCpuTimeInNanos() {
        return this.totalCpuTimeInNanos;
    }

    @JsonProperty
    public long getTotalBlockedTimeInNanos() {
        return this.totalBlockedTimeInNanos;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public long getTotalAllocationInBytes() {
        return this.totalAllocationInBytes;
    }

    @JsonProperty
    public long getRawInputDataSizeInBytes() {
        return this.rawInputDataSizeInBytes;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public long getProcessedInputDataSizeInBytes() {
        return this.processedInputDataSizeInBytes;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public long getOutputDataSizeInBytes() {
        return this.outputDataSizeInBytes;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public long getPhysicalWrittenDataSizeInBytes() {
        return this.physicalWrittenDataSizeInBytes;
    }

    @JsonProperty
    public List<PipelineStats> getPipelines() {
        return this.pipelines;
    }

    @JsonProperty
    public int getQueuedPartitionedDrivers() {
        return this.queuedPartitionedDrivers;
    }

    @JsonProperty
    public int getRunningPartitionedDrivers() {
        return this.runningPartitionedDrivers;
    }

    @JsonProperty
    public int getFullGcCount() {
        return this.fullGcCount;
    }

    @JsonProperty
    public long getFullGcTimeInMillis() {
        return this.fullGcTimeInMillis;
    }

    public TaskStats summarize() {
        return new TaskStats(this.createTime, this.firstStartTime, this.lastStartTime, this.lastEndTime, this.endTime, this.elapsedTimeInNanos, this.queuedTimeInNanos, this.totalDrivers, this.queuedDrivers, this.queuedPartitionedDrivers, this.runningDrivers, this.runningPartitionedDrivers, this.blockedDrivers, this.completedDrivers, this.cumulativeUserMemory, this.userMemoryReservationInBytes, this.revocableMemoryReservationInBytes, this.systemMemoryReservationInBytes, this.peakTotalMemoryInBytes, this.peakUserMemoryInBytes, this.peakNodeTotalMemoryInBytes, this.totalScheduledTimeInNanos, this.totalCpuTimeInNanos, this.totalBlockedTimeInNanos, this.fullyBlocked, this.blockedReasons, this.totalAllocationInBytes, this.rawInputDataSizeInBytes, this.rawInputPositions, this.processedInputDataSizeInBytes, this.processedInputPositions, this.outputDataSizeInBytes, this.outputPositions, this.physicalWrittenDataSizeInBytes, this.fullGcCount, this.fullGcTimeInMillis, (List<PipelineStats>)ImmutableList.of());
    }

    public TaskStats summarizeFinal() {
        return new TaskStats(this.createTime, this.firstStartTime, this.lastStartTime, this.lastEndTime, this.endTime, this.elapsedTimeInNanos, this.queuedTimeInNanos, this.totalDrivers, this.queuedDrivers, this.queuedPartitionedDrivers, this.runningDrivers, this.runningPartitionedDrivers, this.blockedDrivers, this.completedDrivers, this.cumulativeUserMemory, this.userMemoryReservationInBytes, this.revocableMemoryReservationInBytes, this.systemMemoryReservationInBytes, this.peakTotalMemoryInBytes, this.peakUserMemoryInBytes, this.peakNodeTotalMemoryInBytes, this.totalScheduledTimeInNanos, this.totalCpuTimeInNanos, this.totalBlockedTimeInNanos, this.fullyBlocked, this.blockedReasons, this.totalAllocationInBytes, this.rawInputDataSizeInBytes, this.rawInputPositions, this.processedInputDataSizeInBytes, this.processedInputPositions, this.outputDataSizeInBytes, this.outputPositions, this.physicalWrittenDataSizeInBytes, this.fullGcCount, this.fullGcTimeInMillis, this.pipelines.stream().map(PipelineStats::summarize).collect(Collectors.toList()));
    }
}

