/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LazyBlock;
import com.facebook.presto.common.block.LazyBlockLoader;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.SplitOperatorInfo;
import com.facebook.presto.operator.project.CursorProcessor;
import com.facebook.presto.operator.project.CursorProcessorOutput;
import com.facebook.presto.operator.project.MergingPageOutput;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.split.EmptySplit;
import com.facebook.presto.split.EmptySplitPageSource;
import com.facebook.presto.split.PageSourceProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class ScanFilterAndProjectOperator
implements SourceOperator,
Closeable {
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final PageSourceProvider pageSourceProvider;
    private final TableHandle table;
    private final List<ColumnHandle> columns;
    private final PageBuilder pageBuilder;
    private final CursorProcessor cursorProcessor;
    private final PageProcessor pageProcessor;
    private final LocalMemoryContext pageSourceMemoryContext;
    private final LocalMemoryContext pageProcessorMemoryContext;
    private final LocalMemoryContext outputMemoryContext;
    private final SettableFuture<?> blocked = SettableFuture.create();
    private final Optional<Supplier<TupleDomain<ColumnHandle>>> dynamicFilterSupplier;
    private final MergingPageOutput mergingOutput;
    private RecordCursor cursor;
    private ConnectorPageSource pageSource;
    private Split split;
    private boolean finishing;
    private long completedBytes;
    private long completedPositions;
    private long readTimeNanos;

    protected ScanFilterAndProjectOperator(OperatorContext operatorContext, PlanNodeId sourceId, PageSourceProvider pageSourceProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, TableHandle table, Iterable<ColumnHandle> columns, Iterable<Type> types, Optional<Supplier<TupleDomain<ColumnHandle>>> dynamicFilterSupplier, MergingPageOutput mergingOutput) {
        this.cursorProcessor = Objects.requireNonNull(cursorProcessor, "cursorProcessor is null");
        this.pageProcessor = Objects.requireNonNull(pageProcessor, "pageProcessor is null");
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.planNodeId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
        this.pageSourceMemoryContext = operatorContext.newLocalSystemMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
        this.pageProcessorMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
        this.outputMemoryContext = operatorContext.newLocalSystemMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
        this.dynamicFilterSupplier = Objects.requireNonNull(dynamicFilterSupplier, "dynamicFilterSupplier is null");
        this.mergingOutput = Objects.requireNonNull(mergingOutput, "mergingOutput is null");
        this.pageBuilder = new PageBuilder((List)ImmutableList.copyOf(Objects.requireNonNull(types, "types is null")));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkState((this.split == null ? 1 : 0) != 0, (Object)"Table scan split already set");
        if (this.finishing) {
            return Optional::empty;
        }
        this.split = split;
        Object splitInfo = split.getInfo();
        if (splitInfo != null) {
            this.operatorContext.setInfoSupplier(() -> new SplitOperatorInfo(splitInfo));
        }
        this.blocked.set(null);
        if (split.getConnectorSplit() instanceof EmptySplit) {
            this.pageSource = new EmptySplitPageSource();
        }
        return () -> {
            if (this.pageSource instanceof UpdatablePageSource) {
                return Optional.of((UpdatablePageSource)this.pageSource);
            }
            return Optional.empty();
        };
    }

    @Override
    public void noMoreSplits() {
        if (this.split == null) {
            this.finishing = true;
            this.mergingOutput.finish();
        }
        this.blocked.set(null);
    }

    @Override
    public void close() {
        this.finish();
    }

    @Override
    public void finish() {
        this.blocked.set(null);
        if (this.pageSource != null) {
            try {
                this.pageSource.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else if (this.cursor != null) {
            this.cursor.close();
        }
        this.finishing = true;
        this.mergingOutput.finish();
    }

    @Override
    public final boolean isFinished() {
        return this.finishing && this.pageBuilder.isEmpty() && this.mergingOutput.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (!this.blocked.isDone()) {
            return this.blocked;
        }
        if (this.pageSource != null) {
            CompletableFuture pageSourceBlocked = this.pageSource.isBlocked();
            return pageSourceBlocked.isDone() ? NOT_BLOCKED : MoreFutures.toListenableFuture((CompletableFuture)pageSourceBlocked);
        }
        return NOT_BLOCKED;
    }

    @Override
    public final boolean needsInput() {
        return false;
    }

    @Override
    public final void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (this.split == null) {
            return null;
        }
        if (!this.finishing && this.pageSource == null && this.cursor == null) {
            ConnectorPageSource source = this.pageSourceProvider.createPageSource(this.operatorContext.getSession(), this.split, this.dynamicFilterSupplier.map(arg_0 -> ((TableHandle)this.table).withDynamicFilter(arg_0)).orElse(this.table), this.columns);
            if (source instanceof RecordPageSource) {
                this.cursor = ((RecordPageSource)source).getCursor();
            } else {
                this.pageSource = source;
            }
        }
        if (this.pageSource != null) {
            return this.processPageSource();
        }
        return this.processColumnSource();
    }

    private Page processColumnSource() {
        DriverYieldSignal yieldSignal = this.operatorContext.getDriverContext().getYieldSignal();
        if (!this.finishing && !yieldSignal.isSet()) {
            CursorProcessorOutput output = this.cursorProcessor.process(this.operatorContext.getSession().getSqlFunctionProperties(), yieldSignal, this.cursor, this.pageBuilder);
            this.pageSourceMemoryContext.setBytes(this.cursor.getSystemMemoryUsage());
            this.recordCursorInputStats(output.getProcessedRows());
            if (output.isNoMoreRows()) {
                this.finishing = true;
                this.mergingOutput.finish();
            }
        }
        Page page = null;
        if (!this.pageBuilder.isEmpty() && (this.finishing || this.pageBuilder.isFull())) {
            page = this.pageBuilder.build();
            this.pageBuilder.reset();
        }
        this.outputMemoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
        return page;
    }

    private Page processPageSource() {
        DriverYieldSignal yieldSignal = this.operatorContext.getDriverContext().getYieldSignal();
        if (!this.finishing && this.mergingOutput.needsInput() && !yieldSignal.isSet()) {
            Page page = this.pageSource.getNextPage();
            this.finishing = this.pageSource.isFinished();
            this.pageSourceMemoryContext.setBytes(this.pageSource.getSystemMemoryUsage());
            if (page != null) {
                page = this.recordProcessedInput(page);
                Iterator<Optional<Page>> output = this.pageProcessor.process(this.operatorContext.getSession().getSqlFunctionProperties(), yieldSignal, this.pageProcessorMemoryContext, page);
                this.mergingOutput.addInput(output);
            }
            if (this.finishing) {
                this.mergingOutput.finish();
            }
        }
        Page result = this.mergingOutput.getOutput();
        this.outputMemoryContext.setBytes(this.mergingOutput.getRetainedSizeInBytes() + this.pageProcessorMemoryContext.getBytes());
        return result;
    }

    private void recordCursorInputStats(long positionCount) {
        Preconditions.checkState((this.cursor != null ? 1 : 0) != 0, (Object)"cursor is null");
        long endCompletedBytes = this.cursor.getCompletedBytes();
        long endReadTimeNanos = this.cursor.getReadTimeNanos();
        long inputBytes = endCompletedBytes - this.completedBytes;
        this.operatorContext.recordProcessedInput(inputBytes, positionCount);
        this.operatorContext.recordRawInputWithTiming(inputBytes, positionCount, endReadTimeNanos - this.readTimeNanos);
        this.completedBytes = endCompletedBytes;
        this.readTimeNanos = endReadTimeNanos;
    }

    private void recordInputStats() {
        Preconditions.checkState((this.pageSource != null ? 1 : 0) != 0, (Object)"pageSource is null");
        long endCompletedBytes = this.pageSource.getCompletedBytes();
        long endCompletedPositions = this.pageSource.getCompletedPositions();
        long endReadTimeNanos = this.pageSource.getReadTimeNanos();
        long inputBytes = endCompletedBytes - this.completedBytes;
        long positionCount = endCompletedPositions - this.completedPositions;
        this.operatorContext.recordProcessedInput(inputBytes, positionCount);
        this.operatorContext.recordRawInputWithTiming(inputBytes, positionCount, endReadTimeNanos - this.readTimeNanos);
        this.completedBytes = endCompletedBytes;
        this.completedPositions = endCompletedPositions;
        this.readTimeNanos = endReadTimeNanos;
    }

    private Page recordProcessedInput(Page page) {
        long blockSizeSum = 0L;
        Block[] blocks = null;
        for (int i = 0; i < page.getChannelCount(); ++i) {
            Block block = page.getBlock(i);
            if (block instanceof LazyBlock && !((LazyBlock)block).isLoaded()) {
                if (blocks == null) {
                    blocks = ScanFilterAndProjectOperator.copyOfPageBlocks(page);
                }
                blocks[i] = new LazyBlock(page.getPositionCount(), (LazyBlockLoader)new RecordingLazyBlockLoader((LazyBlock)block));
                continue;
            }
            blockSizeSum += block.getSizeInBytes();
        }
        this.recordInputStats();
        return blocks == null ? page : new Page(page.getPositionCount(), blocks);
    }

    private static Block[] copyOfPageBlocks(Page page) {
        Block[] blocks = new Block[page.getChannelCount()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = page.getBlock(i);
        }
        return blocks;
    }

    public static class ScanFilterAndProjectOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Supplier<CursorProcessor> cursorProcessor;
        private final Supplier<PageProcessor> pageProcessor;
        private final PlanNodeId sourceId;
        private final PageSourceProvider pageSourceProvider;
        private final TableHandle table;
        private final List<ColumnHandle> columns;
        private final List<Type> types;
        private final Optional<Supplier<TupleDomain<ColumnHandle>>> dynamicFilterSupplier;
        private final DataSize minOutputPageSize;
        private final int minOutputPageRowCount;
        private boolean closed;

        public ScanFilterAndProjectOperatorFactory(int operatorId, PlanNodeId planNodeId, PlanNodeId sourceId, PageSourceProvider pageSourceProvider, Supplier<CursorProcessor> cursorProcessor, Supplier<PageProcessor> pageProcessor, TableHandle table, Iterable<ColumnHandle> columns, List<Type> types, Optional<Supplier<TupleDomain<ColumnHandle>>> dynamicFilterSupplier, DataSize minOutputPageSize, int minOutputPageRowCount) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.cursorProcessor = Objects.requireNonNull(cursorProcessor, "cursorProcessor is null");
            this.pageProcessor = Objects.requireNonNull(pageProcessor, "pageProcessor is null");
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
            this.types = Objects.requireNonNull(types, "types is null");
            this.dynamicFilterSupplier = Objects.requireNonNull(dynamicFilterSupplier, "dynamicFilterSupplier is null");
            this.minOutputPageSize = Objects.requireNonNull(minOutputPageSize, "minOutputPageSize is null");
            this.minOutputPageRowCount = minOutputPageRowCount;
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, ScanFilterAndProjectOperator.class.getSimpleName());
            return new ScanFilterAndProjectOperator(operatorContext, this.sourceId, this.pageSourceProvider, this.cursorProcessor.get(), this.pageProcessor.get(), this.table, this.columns, this.types, this.dynamicFilterSupplier, new MergingPageOutput(this.types, this.minOutputPageSize.toBytes(), this.minOutputPageRowCount));
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }

    private final class RecordingLazyBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private LazyBlock delegateLazyBlock;

        private RecordingLazyBlockLoader(LazyBlock delegateLazyBlock) {
            this.delegateLazyBlock = Objects.requireNonNull(delegateLazyBlock, "delegateLazyBlock is null");
        }

        public void load(LazyBlock block) {
            Preconditions.checkState((this.delegateLazyBlock != null ? 1 : 0) != 0, (Object)"delegateLazyBlock already loaded");
            Block loadedBlock = this.delegateLazyBlock.getLoadedBlock();
            this.delegateLazyBlock = null;
            ScanFilterAndProjectOperator.this.recordInputStats();
            block.setBlock(loadedBlock);
        }
    }
}

