/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.spi.plan.AggregationNode;
import com.google.common.base.Preconditions;

class Aggregator {
    private final Accumulator aggregation;
    private final AggregationNode.Step step;
    private final int intermediateChannel;

    Aggregator(AccumulatorFactory accumulatorFactory, AggregationNode.Step step, UpdateMemory updateMemory) {
        if (step.isInputRaw()) {
            this.intermediateChannel = -1;
            this.aggregation = accumulatorFactory.createAccumulator(updateMemory);
        } else {
            Preconditions.checkArgument((accumulatorFactory.getInputChannels().size() == 1 ? 1 : 0) != 0, (Object)"expected 1 input channel for intermediate aggregation");
            this.intermediateChannel = accumulatorFactory.getInputChannels().get(0);
            this.aggregation = accumulatorFactory.createIntermediateAccumulator();
        }
        this.step = step;
    }

    public Type getType() {
        if (this.step.isOutputPartial()) {
            return this.aggregation.getIntermediateType();
        }
        return this.aggregation.getFinalType();
    }

    public void processPage(Page page) {
        if (this.step.isInputRaw()) {
            this.aggregation.addInput(page);
        } else {
            this.aggregation.addIntermediate(page.getBlock(this.intermediateChannel));
        }
    }

    public void evaluate(BlockBuilder blockBuilder) {
        if (this.step.isOutputPartial()) {
            this.aggregation.evaluateIntermediate(blockBuilder);
        } else {
            this.aggregation.evaluateFinal(blockBuilder);
        }
    }

    public long getEstimatedSize() {
        return this.aggregation.getEstimatedSize();
    }
}

