/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.connector.Connector;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class Catalog {
    private final String catalogName;
    private final ConnectorId connectorId;
    private final Connector connector;
    private final ConnectorId informationSchemaId;
    private final Connector informationSchema;
    private final ConnectorId systemTablesId;
    private final Connector systemTables;

    public Catalog(String catalogName, ConnectorId connectorId, Connector connector, ConnectorId informationSchemaId, Connector informationSchema, ConnectorId systemTablesId, Connector systemTables) {
        this.catalogName = MetadataUtil.checkCatalogName(catalogName);
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.connector = Objects.requireNonNull(connector, "connector is null");
        this.informationSchemaId = Objects.requireNonNull(informationSchemaId, "informationSchemaId is null");
        this.informationSchema = Objects.requireNonNull(informationSchema, "informationSchema is null");
        this.systemTablesId = Objects.requireNonNull(systemTablesId, "systemTablesId is null");
        this.systemTables = Objects.requireNonNull(systemTables, "systemTables is null");
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    public ConnectorId getInformationSchemaId() {
        return this.informationSchemaId;
    }

    public ConnectorId getSystemTablesId() {
        return this.systemTablesId;
    }

    public Connector getConnector(ConnectorId connectorId) {
        if (this.connectorId.equals((Object)connectorId)) {
            return this.connector;
        }
        if (this.informationSchemaId.equals((Object)connectorId)) {
            return this.informationSchema;
        }
        if (this.systemTablesId.equals((Object)connectorId)) {
            return this.systemTables;
        }
        throw new IllegalArgumentException("Unknown connector id: " + connectorId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("connectorId", (Object)this.connectorId).toString();
    }
}

