/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import java.util.Objects;

@ThriftStruct
public class ResourceGroupRuntimeInfo {
    private final ResourceGroupId resourceGroupId;
    private final long userMemoryReservationBytes;
    private final int queuedQueries;
    private final int runningQueries;

    @ThriftConstructor
    public ResourceGroupRuntimeInfo(ResourceGroupId resourceGroupId, long userMemoryReservationBytes, int queuedQueries, int runningQueries) {
        this.resourceGroupId = Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        this.userMemoryReservationBytes = userMemoryReservationBytes;
        this.queuedQueries = queuedQueries;
        this.runningQueries = runningQueries;
    }

    public static Builder builder(ResourceGroupId resourceGroupId) {
        return new Builder(resourceGroupId);
    }

    @ThriftField(value=1)
    public ResourceGroupId getResourceGroupId() {
        return this.resourceGroupId;
    }

    @ThriftField(value=2)
    public long getUserMemoryReservationBytes() {
        return this.userMemoryReservationBytes;
    }

    @ThriftField(value=3)
    public int getQueuedQueries() {
        return this.queuedQueries;
    }

    @ThriftField(value=4)
    public int getRunningQueries() {
        return this.runningQueries;
    }

    public static class Builder {
        private final ResourceGroupId resourceGroupId;
        private long userMemoryReservationBytes;
        private int queuedQueries;
        private int runningQueries;

        private Builder(ResourceGroupId resourceGroupId) {
            this.resourceGroupId = resourceGroupId;
        }

        public Builder addUserMemoryReservationBytes(long userMemoryReservationBytes) {
            this.userMemoryReservationBytes = Math.addExact(this.userMemoryReservationBytes, userMemoryReservationBytes);
            return this;
        }

        public Builder addQueuedQueries(int queuedQueries) {
            this.queuedQueries = Math.addExact(this.queuedQueries, queuedQueries);
            return this;
        }

        public Builder addRunningQueries(int runningQueries) {
            this.runningQueries = Math.addExact(this.runningQueries, runningQueries);
            return this;
        }

        public ResourceGroupRuntimeInfo build() {
            return new ResourceGroupRuntimeInfo(this.resourceGroupId, this.userMemoryReservationBytes, this.queuedQueries, this.runningQueries);
        }
    }
}

