/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.memory.TraversingQueryContextVisitor;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.TaskContext;
import java.util.Collection;
import java.util.List;

public class MemoryRevokingSchedulerUtils {
    private MemoryRevokingSchedulerUtils() {
    }

    public static long getMemoryAlreadyBeingRevoked(Collection<TaskContext> taskContexts, long targetRevokingLimit) {
        TraversingQueryContextVisitor<Void, Long> visitor = new TraversingQueryContextVisitor<Void, Long>(){

            @Override
            public Long visitOperatorContext(OperatorContext operatorContext, Void context) {
                if (operatorContext.isMemoryRevokingRequested()) {
                    return operatorContext.getReservedRevocableBytes();
                }
                return 0L;
            }

            @Override
            public Long mergeResults(List<Long> childrenResults) {
                return childrenResults.stream().mapToLong(i -> i).sum();
            }
        };
        long currentRevoking = 0L;
        for (TaskContext taskContext : taskContexts) {
            if ((currentRevoking += taskContext.accept(visitor, null).longValue()) <= targetRevokingLimit) continue;
            return currentRevoking;
        }
        return currentRevoking;
    }
}

