/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.dispatcher.DefaultQueryPrerequisites;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.prerequisites.QueryPrerequisites;
import com.facebook.presto.spi.prerequisites.QueryPrerequisitesContext;
import com.facebook.presto.spi.prerequisites.QueryPrerequisitesFactory;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class QueryPrerequisitesManager
implements QueryPrerequisites {
    private static final Logger log = Logger.get(QueryPrerequisitesManager.class);
    private static final File QUERY_PREREQUISITES_CONFIG = new File("etc/query-prerequisites.properties");
    private static final String QUERY_PREREQUISITES_PROPERTY_NAME = "query-prerequisites.factory";
    private final Map<String, QueryPrerequisitesFactory> queryPrerequisitesFactories = new ConcurrentHashMap<String, QueryPrerequisitesFactory>();
    private final QueryPrerequisites defaultQueryPrerequisites = new DefaultQueryPrerequisites();
    private final AtomicReference<QueryPrerequisites> queryPrerequisites = new AtomicReference<QueryPrerequisites>(this.defaultQueryPrerequisites);

    public void addQueryPrerequisitesFactory(QueryPrerequisitesFactory queryPrerequisitesFactory) {
        Objects.requireNonNull(queryPrerequisitesFactory, "queryPrerequisitesFactory is null");
        if (this.queryPrerequisitesFactories.putIfAbsent(queryPrerequisitesFactory.getName(), queryPrerequisitesFactory) != null) {
            throw new IllegalArgumentException(String.format("Query Prerequisites '%s' is already registered", queryPrerequisitesFactory.getName()));
        }
    }

    public void loadQueryPrerequisites() throws Exception {
        if (QUERY_PREREQUISITES_CONFIG.exists()) {
            HashMap<String, String> properties = new HashMap<String, String>(PropertiesUtil.loadProperties(QUERY_PREREQUISITES_CONFIG));
            String factoryName = (String)properties.remove(QUERY_PREREQUISITES_PROPERTY_NAME);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)factoryName) ? 1 : 0) != 0, (String)"Query Prerequisites configuration %s does not contain %s", (Object)QUERY_PREREQUISITES_CONFIG.getAbsoluteFile(), (Object)QUERY_PREREQUISITES_PROPERTY_NAME);
            log.info("-- Loading query prerequisites factory --");
            QueryPrerequisitesFactory queryPrerequisitesFactory = this.queryPrerequisitesFactories.get(factoryName);
            Preconditions.checkState((queryPrerequisitesFactory != null ? 1 : 0) != 0, (String)"Query prerequisites factory %s is not registered", (Object)factoryName);
            QueryPrerequisites queryPrerequisites = queryPrerequisitesFactory.create(properties);
            Preconditions.checkState((boolean)this.queryPrerequisites.compareAndSet(this.defaultQueryPrerequisites, queryPrerequisites), (Object)"Query prerequisites has already been set");
            log.info("-- Loaded query prerequisites %s --", new Object[]{factoryName});
        }
    }

    public CompletableFuture<?> waitForPrerequisites(QueryId queryId, QueryPrerequisitesContext context) {
        Preconditions.checkState((this.queryPrerequisites.get() != null ? 1 : 0) != 0, (Object)"Query prerequisites not initiated");
        return this.queryPrerequisites.get().waitForPrerequisites(queryId, context);
    }

    public void queryFinished(QueryId queryId) {
        Preconditions.checkState((this.queryPrerequisites.get() != null ? 1 : 0) != 0, (Object)"Query prerequisites not initiated");
        this.queryPrerequisites.get().queryFinished(queryId);
    }
}

