/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.presto.Session;
import com.facebook.presto.dispatcher.DispatchInfo;
import com.facebook.presto.dispatcher.DispatchQuery;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class FailedDispatchQuery
implements DispatchQuery {
    private final BasicQueryInfo basicQueryInfo;
    private final Session session;
    private final Executor executor;
    private final DispatchInfo dispatchInfo;

    public FailedDispatchQuery(Session session, String query, URI self, Optional<ResourceGroupId> resourceGroup, ExecutionFailureInfo failure, Executor executor) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(self, "self is null");
        Objects.requireNonNull(resourceGroup, "resourceGroup is null");
        Objects.requireNonNull(failure, "failure is null");
        Objects.requireNonNull(executor, "executor is null");
        this.basicQueryInfo = BasicQueryInfo.immediateFailureQueryInfo(session, query, self, resourceGroup, failure);
        this.session = Objects.requireNonNull(session, "session is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.dispatchInfo = DispatchInfo.failed(failure, this.basicQueryInfo.getQueryStats().getElapsedTime(), this.basicQueryInfo.getQueryStats().getWaitingForPrerequisitesTime(), this.basicQueryInfo.getQueryStats().getQueuedTime());
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.basicQueryInfo;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public ListenableFuture<?> getDispatchedFuture() {
        return Futures.immediateFuture(null);
    }

    @Override
    public DispatchInfo getDispatchInfo() {
        return this.dispatchInfo;
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.executor.execute(() -> stateChangeListener.stateChanged(QueryState.FAILED));
    }

    @Override
    public void startWaitingForPrerequisites() {
    }

    @Override
    public void startWaitingForResources() {
    }

    @Override
    public void fail(Throwable throwable) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void pruneInfo() {
    }

    @Override
    public QueryId getQueryId() {
        return this.basicQueryInfo.getQueryId();
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public Optional<ErrorCode> getErrorCode() {
        return Optional.ofNullable(this.basicQueryInfo.getErrorCode());
    }

    @Override
    public boolean isRetry() {
        return false;
    }

    @Override
    public void recordHeartbeat() {
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.basicQueryInfo.getQueryStats().getEndTime();
    }

    @Override
    public DateTime getCreateTime() {
        return this.basicQueryInfo.getQueryStats().getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.getEndTime();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return Optional.ofNullable(this.basicQueryInfo.getQueryStats().getEndTime());
    }

    @Override
    public Duration getTotalCpuTime() {
        return new Duration(0.0, TimeUnit.MILLISECONDS);
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        return new DataSize(0.0, DataSize.Unit.BYTE);
    }

    @Override
    public DataSize getUserMemoryReservation() {
        return new DataSize(0.0, DataSize.Unit.BYTE);
    }
}

