/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.HyperLogLogType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.type.CodePointsType;
import com.facebook.presto.type.JoniRegexpType;
import com.facebook.presto.type.JsonPathType;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.type.Re2JRegexpType;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TypeCoercer {
    private final FeaturesConfig featuresConfig;
    private final FunctionAndTypeManager functionAndTypeManager;

    public TypeCoercer(FeaturesConfig featuresConfig, FunctionAndTypeManager functionAndTypeManager) {
        this.featuresConfig = Objects.requireNonNull(featuresConfig, "featuresConfig is null");
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
    }

    public Optional<Type> getCommonSuperType(Type firstType, Type secondType) {
        TypeCompatibility compatibility = this.compatibility(firstType, secondType);
        if (!compatibility.isCompatible()) {
            return Optional.empty();
        }
        return Optional.of(compatibility.getCommonSuperType());
    }

    public boolean canCoerce(Type fromType, Type toType) {
        TypeCompatibility typeCompatibility = this.compatibility(fromType, toType);
        return typeCompatibility.isCoercible();
    }

    public boolean isTypeOnlyCoercion(Type source, Type result) {
        String resultTypeBase;
        if (source.equals(result)) {
            return true;
        }
        if (!this.canCoerce(source, result)) {
            return false;
        }
        if (source instanceof VarcharType && result instanceof VarcharType) {
            return true;
        }
        if (source instanceof DecimalType && result instanceof DecimalType) {
            DecimalType sourceDecimal = (DecimalType)source;
            DecimalType resultDecimal = (DecimalType)result;
            boolean sameDecimalSubtype = sourceDecimal.isShort() && resultDecimal.isShort() || !sourceDecimal.isShort() && !resultDecimal.isShort();
            boolean sameScale = sourceDecimal.getScale() == resultDecimal.getScale();
            boolean sourcePrecisionIsLessOrEqualToResultPrecision = sourceDecimal.getPrecision() <= resultDecimal.getPrecision();
            return sameDecimalSubtype && sameScale && sourcePrecisionIsLessOrEqualToResultPrecision;
        }
        String sourceTypeBase = source.getTypeSignature().getBase();
        if (sourceTypeBase.equals(resultTypeBase = result.getTypeSignature().getBase()) && TypeCoercer.isCovariantParametrizedType(source)) {
            List sourceTypeParameters = source.getTypeParameters();
            List resultTypeParameters = result.getTypeParameters();
            Preconditions.checkState((sourceTypeParameters.size() == resultTypeParameters.size() ? 1 : 0) != 0);
            for (int i = 0; i < sourceTypeParameters.size(); ++i) {
                if (this.isTypeOnlyCoercion((Type)sourceTypeParameters.get(i), (Type)resultTypeParameters.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Optional<Type> coerceTypeBase(Type sourceType, String resultTypeBase) {
        String sourceTypeName = sourceType.getTypeSignature().getBase();
        if (sourceTypeName.equals(resultTypeBase)) {
            return Optional.of(sourceType);
        }
        switch (sourceTypeName) {
            case "unknown": {
                switch (resultTypeBase) {
                    case "boolean": 
                    case "bigint": 
                    case "integer": 
                    case "double": 
                    case "real": 
                    case "varbinary": 
                    case "date": 
                    case "time": 
                    case "time with time zone": 
                    case "timestamp": 
                    case "timestamp with time zone": 
                    case "HyperLogLog": 
                    case "SetDigest": 
                    case "P4HyperLogLog": 
                    case "json": 
                    case "interval year to month": 
                    case "interval day to second": 
                    case "KHyperLogLog": 
                    case "JoniRegExp": 
                    case "LikePattern": 
                    case "JsonPath": 
                    case "color": 
                    case "CodePoints": {
                        return Optional.of(this.functionAndTypeManager.getType(new TypeSignature(resultTypeBase, new TypeSignatureParameter[0])));
                    }
                    case "varchar": {
                        return Optional.of(VarcharType.createVarcharType((int)0));
                    }
                    case "char": {
                        return Optional.of(CharType.createCharType((long)0L));
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)1, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "tinyint": {
                switch (resultTypeBase) {
                    case "smallint": {
                        return Optional.of(SmallintType.SMALLINT);
                    }
                    case "integer": {
                        return Optional.of(IntegerType.INTEGER);
                    }
                    case "bigint": {
                        return Optional.of(BigintType.BIGINT);
                    }
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)3, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "smallint": {
                switch (resultTypeBase) {
                    case "integer": {
                        return Optional.of(IntegerType.INTEGER);
                    }
                    case "bigint": {
                        return Optional.of(BigintType.BIGINT);
                    }
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)5, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "integer": {
                switch (resultTypeBase) {
                    case "bigint": {
                        return Optional.of(BigintType.BIGINT);
                    }
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)10, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "bigint": {
                switch (resultTypeBase) {
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)19, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "decimal": {
                switch (resultTypeBase) {
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                }
                return Optional.empty();
            }
            case "real": {
                switch (resultTypeBase) {
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                }
                return Optional.empty();
            }
            case "date": {
                switch (resultTypeBase) {
                    case "timestamp": {
                        return Optional.of(TimestampType.TIMESTAMP);
                    }
                    case "timestamp with time zone": {
                        return Optional.of(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
                    }
                }
                return Optional.empty();
            }
            case "time": {
                switch (resultTypeBase) {
                    case "time with time zone": {
                        return Optional.of(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
                    }
                }
                return Optional.empty();
            }
            case "timestamp": {
                switch (resultTypeBase) {
                    case "timestamp with time zone": {
                        return Optional.of(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
                    }
                }
                return Optional.empty();
            }
            case "varchar": {
                switch (resultTypeBase) {
                    case "char": {
                        if (this.featuresConfig.isLegacyCharToVarcharCoercion()) {
                            return Optional.empty();
                        }
                        VarcharType varcharType = (VarcharType)sourceType;
                        if (varcharType.isUnbounded()) {
                            return Optional.of(CharType.createCharType((long)65536L));
                        }
                        return Optional.of(CharType.createCharType((long)Math.min(65536, varcharType.getLengthSafe())));
                    }
                    case "JoniRegExp": {
                        return Optional.of(JoniRegexpType.JONI_REGEXP);
                    }
                    case "Re2JRegExp": {
                        return Optional.of(Re2JRegexpType.RE2J_REGEXP);
                    }
                    case "LikePattern": {
                        return Optional.of(LikePatternType.LIKE_PATTERN);
                    }
                    case "JsonPath": {
                        return Optional.of(JsonPathType.JSON_PATH);
                    }
                    case "CodePoints": {
                        return Optional.of(CodePointsType.CODE_POINTS);
                    }
                }
                return Optional.empty();
            }
            case "char": {
                switch (resultTypeBase) {
                    case "varchar": {
                        if (!this.featuresConfig.isLegacyCharToVarcharCoercion()) {
                            return Optional.empty();
                        }
                        CharType charType = (CharType)sourceType;
                        return Optional.of(VarcharType.createVarcharType((int)charType.getLength()));
                    }
                    case "JoniRegExp": {
                        return Optional.of(JoniRegexpType.JONI_REGEXP);
                    }
                    case "Re2JRegExp": {
                        return Optional.of(Re2JRegexpType.RE2J_REGEXP);
                    }
                    case "LikePattern": {
                        return Optional.of(LikePatternType.LIKE_PATTERN);
                    }
                    case "JsonPath": {
                        return Optional.of(JsonPathType.JSON_PATH);
                    }
                    case "CodePoints": {
                        return Optional.of(CodePointsType.CODE_POINTS);
                    }
                }
                return Optional.empty();
            }
            case "P4HyperLogLog": {
                switch (resultTypeBase) {
                    case "HyperLogLog": {
                        return Optional.of(HyperLogLogType.HYPER_LOG_LOG);
                    }
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static boolean isCovariantParametrizedType(Type type) {
        return type instanceof MapType || type instanceof ArrayType;
    }

    private TypeCompatibility compatibility(Type fromType, Type toType) {
        if (fromType.equals(toType)) {
            return TypeCompatibility.compatible(toType, true);
        }
        if (fromType.equals((Object)UnknownType.UNKNOWN)) {
            return TypeCompatibility.compatible(toType, true);
        }
        if (toType.equals((Object)UnknownType.UNKNOWN)) {
            return TypeCompatibility.compatible(fromType, false);
        }
        String fromTypeBaseName = fromType.getTypeSignature().getBase();
        String toTypeBaseName = toType.getTypeSignature().getBase();
        if (this.featuresConfig.isLegacyDateTimestampToVarcharCoercion()) {
            if ((fromTypeBaseName.equals("date") || fromTypeBaseName.equals("timestamp")) && toTypeBaseName.equals("varchar")) {
                return TypeCompatibility.compatible(toType, true);
            }
            if (fromTypeBaseName.equals("varchar") && (toTypeBaseName.equals("date") || toTypeBaseName.equals("timestamp"))) {
                return TypeCompatibility.compatible(fromType, true);
            }
        }
        if (fromTypeBaseName.equals(toTypeBaseName)) {
            if (fromTypeBaseName.equals("decimal")) {
                Type commonSuperType = TypeCoercer.getCommonSuperTypeForDecimal((DecimalType)fromType, (DecimalType)toType);
                return TypeCompatibility.compatible(commonSuperType, commonSuperType.equals(toType));
            }
            if (fromTypeBaseName.equals("varchar")) {
                Type commonSuperType = TypeCoercer.getCommonSuperTypeForVarchar((VarcharType)fromType, (VarcharType)toType);
                return TypeCompatibility.compatible(commonSuperType, commonSuperType.equals(toType));
            }
            if (fromTypeBaseName.equals("char") && !this.featuresConfig.isLegacyCharToVarcharCoercion()) {
                Type commonSuperType = TypeCoercer.getCommonSuperTypeForChar((CharType)fromType, (CharType)toType);
                return TypeCompatibility.compatible(commonSuperType, commonSuperType.equals(toType));
            }
            if (fromTypeBaseName.equals("row")) {
                return this.typeCompatibilityForRow((RowType)fromType, (RowType)toType);
            }
            if (TypeCoercer.isCovariantParametrizedType(fromType)) {
                return this.typeCompatibilityForCovariantParametrizedType(fromType, toType);
            }
            return TypeCompatibility.incompatible();
        }
        Optional<Type> coercedType = this.coerceTypeBase(fromType, toType.getTypeSignature().getBase());
        if (coercedType.isPresent()) {
            return this.compatibility(coercedType.get(), toType);
        }
        coercedType = this.coerceTypeBase(toType, fromType.getTypeSignature().getBase());
        if (coercedType.isPresent()) {
            TypeCompatibility typeCompatibility = this.compatibility(fromType, coercedType.get());
            if (!typeCompatibility.isCompatible()) {
                return TypeCompatibility.incompatible();
            }
            return TypeCompatibility.compatible(typeCompatibility.getCommonSuperType(), false);
        }
        return TypeCompatibility.incompatible();
    }

    private static Type getCommonSuperTypeForDecimal(DecimalType firstType, DecimalType secondType) {
        int targetScale = Math.max(firstType.getScale(), secondType.getScale());
        int targetPrecision = Math.max(firstType.getPrecision() - firstType.getScale(), secondType.getPrecision() - secondType.getScale()) + targetScale;
        targetPrecision = Math.min(38, targetPrecision);
        return DecimalType.createDecimalType((int)targetPrecision, (int)targetScale);
    }

    private static Type getCommonSuperTypeForVarchar(VarcharType firstType, VarcharType secondType) {
        if (firstType.isUnbounded() || secondType.isUnbounded()) {
            return VarcharType.createUnboundedVarcharType();
        }
        return VarcharType.createVarcharType((int)Math.max(firstType.getLength(), secondType.getLength()));
    }

    private static Type getCommonSuperTypeForChar(CharType firstType, CharType secondType) {
        return CharType.createCharType((long)Math.max(firstType.getLength(), secondType.getLength()));
    }

    private TypeCompatibility typeCompatibilityForRow(RowType firstType, RowType secondType) {
        List firstFields = firstType.getFields();
        List secondFields = secondType.getFields();
        if (firstFields.size() != secondFields.size()) {
            return TypeCompatibility.incompatible();
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        boolean coercible = true;
        for (int i = 0; i < firstFields.size(); ++i) {
            Optional secondParameterName;
            Type secondFieldType;
            Type firstFieldType = ((RowType.Field)firstFields.get(i)).getType();
            TypeCompatibility typeCompatibility = this.compatibility(firstFieldType, secondFieldType = ((RowType.Field)secondFields.get(i)).getType());
            if (!typeCompatibility.isCompatible()) {
                return TypeCompatibility.incompatible();
            }
            Type commonParameterType = typeCompatibility.getCommonSuperType();
            Optional firstParameterName = ((RowType.Field)firstFields.get(i)).getName();
            Optional commonName = firstParameterName.equals(secondParameterName = ((RowType.Field)secondFields.get(i)).getName()) ? firstParameterName : Optional.empty();
            coercible &= typeCompatibility.isCoercible();
            fields.add((Object)new RowType.Field(commonName, commonParameterType));
        }
        return TypeCompatibility.compatible((Type)RowType.from((List)fields.build()), coercible);
    }

    private TypeCompatibility typeCompatibilityForCovariantParametrizedType(Type fromType, Type toType) {
        Preconditions.checkState((boolean)fromType.getClass().equals(toType.getClass()));
        ImmutableList.Builder commonParameterTypes = ImmutableList.builder();
        List fromTypeParameters = fromType.getTypeParameters();
        List toTypeParameters = toType.getTypeParameters();
        if (fromTypeParameters.size() != toTypeParameters.size()) {
            return TypeCompatibility.incompatible();
        }
        boolean coercible = true;
        for (int i = 0; i < fromTypeParameters.size(); ++i) {
            TypeCompatibility compatibility = this.compatibility((Type)fromTypeParameters.get(i), (Type)toTypeParameters.get(i));
            if (!compatibility.isCompatible()) {
                return TypeCompatibility.incompatible();
            }
            coercible &= compatibility.isCoercible();
            commonParameterTypes.add((Object)TypeSignatureParameter.of((TypeSignature)compatibility.getCommonSuperType().getTypeSignature()));
        }
        String typeBase = fromType.getTypeSignature().getBase();
        return TypeCompatibility.compatible(this.functionAndTypeManager.getType(new TypeSignature(typeBase, (List)commonParameterTypes.build())), coercible);
    }

    private static class TypeCompatibility {
        private final Optional<Type> commonSuperType;
        private final boolean coercible;

        private TypeCompatibility(Optional<Type> commonSuperType, boolean coercible) {
            Preconditions.checkArgument((!coercible || commonSuperType.isPresent() ? 1 : 0) != 0);
            this.commonSuperType = commonSuperType;
            this.coercible = coercible;
        }

        private static TypeCompatibility compatible(Type commonSuperType, boolean coercible) {
            return new TypeCompatibility(Optional.of(commonSuperType), coercible);
        }

        private static TypeCompatibility incompatible() {
            return new TypeCompatibility(Optional.empty(), false);
        }

        private boolean isCompatible() {
            return this.commonSuperType.isPresent();
        }

        private Type getCommonSuperType() {
            Preconditions.checkState((boolean)this.commonSuperType.isPresent(), (Object)"Types are not compatible");
            return this.commonSuperType.get();
        }

        private boolean isCoercible() {
            return this.coercible;
        }
    }
}

