/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.LongEnumType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharEnumType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import io.airlift.slice.Slice;

public final class EnumCasts {
    private EnumCasts() {
    }

    @ScalarOperator(value=OperatorType.CAST)
    @TypeParameter(value="T", boundedBy=VarcharEnumType.class)
    @SqlType(value="T")
    public static Slice castVarcharToEnum(@TypeParameter(value="T") Type enumType, @SqlType(value="varchar") Slice value) {
        if (!((VarcharEnumType)enumType).getEnumMap().values().contains(value.toStringUtf8())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("No value '%s' in enum '%s'", value.toStringUtf8(), enumType.getTypeSignature().getBase()));
        }
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @TypeParameter(value="T", boundedBy=VarcharEnumType.class)
    @SqlType(value="varchar")
    public static Slice castEnumToVarchar(@SqlType(value="T") Slice value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="T")
    public static long castBigintToEnum(@TypeParameter(value="T") Type enumType, @SqlType(value="bigint") long value) {
        return EnumCasts.castLongToEnum(enumType, value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="T")
    public static long castIntegerToEnum(@TypeParameter(value="T") Type enumType, @SqlType(value="integer") long value) {
        return EnumCasts.castLongToEnum(enumType, value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="T")
    public static long castSmallintToEnum(@TypeParameter(value="T") Type enumType, @SqlType(value="smallint") long value) {
        return EnumCasts.castLongToEnum(enumType, value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="T")
    public static long castTinyintToEnum(@TypeParameter(value="T") Type enumType, @SqlType(value="tinyint") long value) {
        return EnumCasts.castLongToEnum(enumType, value);
    }

    private static long castLongToEnum(Type enumType, long value) {
        if (!((LongEnumType)enumType).getEnumMap().values().contains(value)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("No value '%d' in enum '%s'", value, enumType.getTypeSignature().getBase()));
        }
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="bigint")
    public static long castEnumToBigint(@SqlType(value="T") long value) {
        return value;
    }
}

