/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tdigest;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public final class TDigestUtils {
    private static final Random prng = ThreadLocalRandom.current();

    private TDigestUtils() {
    }

    static double weightedAverage(double x1, double w1, double x2, double w2) {
        if (x1 <= x2) {
            return TDigestUtils.weightedAverageSorted(x1, w1, x2, w2);
        }
        return TDigestUtils.weightedAverageSorted(x2, w2, x1, w1);
    }

    private static double weightedAverageSorted(double x1, double w1, double x2, double w2) {
        double x = (x1 * w1 + x2 * w2) / (w1 + w2);
        return Math.max(x1, Math.min(x, x2));
    }

    public static double maxSize(double q, double compression, double n) {
        return TDigestUtils.Z(compression, n) * q * (1.0 - q) / compression;
    }

    public static double maxSize(double q, double normalizer) {
        return q * (1.0 - q) / normalizer;
    }

    public static double normalizer(double compression, double n) {
        return compression / TDigestUtils.Z(compression, n);
    }

    private static double Z(double compression, double n) {
        return 4.0 * Math.log(n / compression) + 24.0;
    }

    public static void sort(int[] order, double[] values) {
        TDigestUtils.sort(order, values, 0, values.length);
    }

    public static void sort(int[] order, double[] values, int n) {
        TDigestUtils.sort(order, values, 0, n);
    }

    public static void sort(int[] order, double[] values, int start, int n) {
        for (int i = start; i < start + n; ++i) {
            order[i] = i;
        }
        TDigestUtils.quickSort(order, values, start, start + n, 64);
        TDigestUtils.insertionSort(order, values, start, start + n, 64);
    }

    private static void quickSort(int[] order, double[] values, int start, int end, int limit) {
        while (end - start > limit) {
            int pivotIndex = start + prng.nextInt(end - start);
            double pivotValue = values[order[pivotIndex]];
            TDigestUtils.swap(order, start, pivotIndex);
            int low = start + 1;
            int high = end;
            int i = low;
            while (i < high) {
                double vi = values[order[i]];
                if (vi == pivotValue) {
                    if (low != i) {
                        TDigestUtils.swap(order, low, i);
                    } else {
                        ++i;
                    }
                    ++low;
                    continue;
                }
                if (vi > pivotValue) {
                    TDigestUtils.swap(order, i, --high);
                    continue;
                }
                ++i;
            }
            int from = start;
            int to = high - 1;
            i = 0;
            while (from < low && to >= low) {
                TDigestUtils.swap(order, from++, to--);
                ++i;
            }
            if ((low = from == low ? to + 1 : from) - start < end - high) {
                TDigestUtils.quickSort(order, values, start, low, limit);
                start = high;
                continue;
            }
            TDigestUtils.quickSort(order, values, high, end, limit);
            end = low;
        }
    }

    public static void sort(double[] key, double[] ... values) {
        TDigestUtils.sort(key, 0, key.length, values);
    }

    public static void sort(double[] key, int start, int n, double[] ... values) {
        TDigestUtils.quickSort(key, values, start, start + n, 8);
        TDigestUtils.insertionSort(key, values, start, start + n, 8);
    }

    private static void quickSort(double[] key, double[][] values, int start, int end, int limit) {
        while (end - start > limit) {
            double pivotValue;
            int pivotIndex;
            int a = start;
            int b = (start + end) / 2;
            int c = end - 1;
            double va = key[a];
            double vb = key[b];
            double vc = key[c];
            if (va > vb) {
                if (vc > va) {
                    pivotIndex = a;
                    pivotValue = va;
                } else if (vc < vb) {
                    pivotIndex = b;
                    pivotValue = vb;
                } else {
                    pivotIndex = c;
                    pivotValue = vc;
                }
            } else if (vc > vb) {
                pivotIndex = b;
                pivotValue = vb;
            } else if (vc < va) {
                pivotIndex = a;
                pivotValue = va;
            } else {
                pivotIndex = c;
                pivotValue = vc;
            }
            TDigestUtils.swap(start, pivotIndex, key, values);
            int low = start + 1;
            int high = end;
            int i = low;
            while (i < high) {
                double vi = key[i];
                if (vi == pivotValue) {
                    if (low != i) {
                        TDigestUtils.swap(low, i, key, values);
                    } else {
                        ++i;
                    }
                    ++low;
                    continue;
                }
                if (vi > pivotValue) {
                    TDigestUtils.swap(i, --high, key, values);
                    continue;
                }
                ++i;
            }
            int from = start;
            int to = high - 1;
            i = 0;
            while (from < low && to >= low) {
                TDigestUtils.swap(from++, to--, key, values);
                ++i;
            }
            if ((low = from == low ? to + 1 : from) - start < end - high) {
                TDigestUtils.quickSort(key, values, start, low, limit);
                start = high;
                continue;
            }
            TDigestUtils.quickSort(key, values, high, end, limit);
            end = low;
        }
    }

    private static void insertionSort(double[] key, double[][] values, int start, int end, int limit) {
        block0: for (int i = start + 1; i < end; ++i) {
            double v = key[i];
            int m = Math.max(i - limit, start);
            for (int j = i; j >= m; --j) {
                if (j != m && !(key[j - 1] <= v)) continue;
                if (j >= i) continue block0;
                System.arraycopy(key, j, key, j + 1, i - j);
                key[j] = v;
                for (double[] value : values) {
                    double tmp = value[i];
                    System.arraycopy(value, j, value, j + 1, i - j);
                    value[j] = tmp;
                }
                continue block0;
            }
        }
    }

    private static void swap(int[] order, int i, int j) {
        int t = order[i];
        order[i] = order[j];
        order[j] = t;
    }

    private static void swap(int i, int j, double[] key, double[] ... values) {
        double t = key[i];
        key[i] = key[j];
        key[j] = t;
        for (int k = 0; k < values.length; ++k) {
            t = values[k][i];
            values[k][i] = values[k][j];
            values[k][j] = t;
        }
    }

    public static void checkPartition(int[] order, double[] values, double pivotValue, int start, int low, int high, int end) {
        double v;
        int i;
        if (order.length != values.length) {
            throw new IllegalArgumentException("Arguments must be same size");
        }
        if (start < 0 || low < start || high < low || end < high) {
            throw new IllegalArgumentException(String.format("Invalid indices %d, %d, %d, %d", start, low, high, end));
        }
        for (i = 0; i < low; ++i) {
            v = values[order[i]];
            if (!(v >= pivotValue)) continue;
            throw new IllegalArgumentException(String.format("Value greater than pivot at %d", i));
        }
        for (i = low; i < high; ++i) {
            if (values[order[i]] == pivotValue) continue;
            throw new IllegalArgumentException(String.format("Non-pivot at %d", i));
        }
        for (i = high; i < end; ++i) {
            v = values[order[i]];
            if (!(v <= pivotValue)) continue;
            throw new IllegalArgumentException(String.format("Value less than pivot at %d", i));
        }
    }

    private static void insertionSort(int[] order, double[] values, int start, int n, int limit) {
        block0: for (int i = start + 1; i < n; ++i) {
            int t = order[i];
            double v = values[order[i]];
            int m = Math.max(i - limit, start);
            for (int j = i; j >= m; --j) {
                if (j != 0 && !(values[order[j - 1]] <= v)) continue;
                if (j >= i) continue block0;
                System.arraycopy(order, j, order, j + 1, i - j);
                order[j] = t;
                continue block0;
            }
        }
    }

    public static void reverse(int[] order) {
        TDigestUtils.reverse(order, 0, order.length);
    }

    public static void reverse(int[] order, int offset, int length) {
        for (int i = 0; i < length / 2; ++i) {
            int t = order[offset + i];
            order[offset + i] = order[offset + length - i - 1];
            order[offset + length - i - 1] = t;
        }
    }

    public static void reverse(double[] order, int offset, int length) {
        for (int i = 0; i < length / 2; ++i) {
            double t = order[offset + i];
            order[offset + i] = order[offset + length - i - 1];
            order[offset + length - i - 1] = t;
        }
    }
}

