/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.storage;

import com.facebook.airlift.log.Logger;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.connector.ConnectorAwareNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.storage.TempStorage;
import com.facebook.presto.spi.storage.TempStorageContext;
import com.facebook.presto.spi.storage.TempStorageFactory;
import com.facebook.presto.spiller.LocalTempStorage;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;

public class TempStorageManager {
    private static final Logger log = Logger.get(TempStorageManager.class);
    private static final File TEMP_STORAGE_CONFIGURATION_DIR = new File("etc/temp-storage/");
    private final Map<String, TempStorageFactory> tempStorageFactories = new ConcurrentHashMap<String, TempStorageFactory>();
    private final Map<String, TempStorage> loadedTempStorages = new ConcurrentHashMap<String, TempStorage>();
    private final AtomicBoolean tempStorageLoading = new AtomicBoolean();
    private final NodeManager nodeManager;

    @Inject
    public TempStorageManager(InternalNodeManager internalNodeManager, NodeInfo nodeInfo) {
        this(new ConnectorAwareNodeManager(Objects.requireNonNull(internalNodeManager, "internalNodeManager is null"), Objects.requireNonNull(nodeInfo, "nodeInfo is null").getEnvironment(), new ConnectorId("system")));
    }

    @VisibleForTesting
    public TempStorageManager(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.addTempStorageFactory(new LocalTempStorage.Factory());
    }

    public void addTempStorageFactory(TempStorageFactory tempStorageFactory) {
        Objects.requireNonNull(tempStorageFactory, "tempStorageFactory is null");
        if (this.tempStorageFactories.putIfAbsent(tempStorageFactory.getName(), tempStorageFactory) != null) {
            throw new IllegalArgumentException(String.format("Temp Storage '%s' is already registered", tempStorageFactory.getName()));
        }
    }

    public void loadTempStorages() throws IOException {
        if (!this.tempStorageLoading.compareAndSet(false, true)) {
            return;
        }
        this.loadTempStorage("local", (Map<String, String>)ImmutableMap.of((Object)"temp-storage.path", (Object)Paths.get(System.getProperty("java.io.tmpdir"), "presto", "temp_storage").toAbsolutePath().toString()));
        for (File file : TempStorageManager.listFiles(TEMP_STORAGE_CONFIGURATION_DIR)) {
            if (!file.isFile() || !file.getName().endsWith(".properties")) continue;
            String name = Files.getNameWithoutExtension((String)file.getName());
            HashMap<String, String> properties = new HashMap<String, String>(PropertiesUtil.loadProperties(file));
            this.loadTempStorage(name, properties);
        }
    }

    public TempStorage getTempStorage(String name) {
        TempStorage tempStorage = this.loadedTempStorages.get(name);
        Preconditions.checkState((tempStorage != null ? 1 : 0) != 0, (String)"tempStorage %s was not loaded", (Object)name);
        return tempStorage;
    }

    protected void loadTempStorage(String name, Map<String, String> properties) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        log.info("-- Loading temp storage --");
        TempStorageFactory factory = this.tempStorageFactories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Temp Storage %s is not registered", (Object)name);
        TempStorage tempStorage = factory.create(properties, new TempStorageContext(this.nodeManager));
        if (this.loadedTempStorages.putIfAbsent(name, tempStorage) != null) {
            throw new IllegalArgumentException(String.format("Temp Storage '%s' is already loaded", name));
        }
        log.info("-- Loaded temp storage %s --", new Object[]{name});
    }

    private static List<File> listFiles(File dir) {
        Object[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }
}

