/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.planPrinter.NodeRepresentation;
import com.facebook.presto.sql.planner.planPrinter.PlanRepresentation;
import com.facebook.presto.sql.planner.planPrinter.Renderer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JsonRenderer
implements Renderer<String> {
    private static final JsonCodec<JsonRenderedNode> CODEC = JsonCodec.jsonCodec(JsonRenderedNode.class);
    private static final JsonCodec<Map<PlanFragmentId, JsonPlanFragment>> PLAN_MAP_CODEC = JsonCodec.mapJsonCodec(PlanFragmentId.class, JsonPlanFragment.class);

    @Override
    public String render(PlanRepresentation plan) {
        return CODEC.toJson((Object)this.renderJson(plan, plan.getRoot()));
    }

    public String render(Map<PlanFragmentId, JsonPlanFragment> fragmentJsonMap) {
        return PLAN_MAP_CODEC.toJson(fragmentJsonMap);
    }

    private JsonRenderedNode renderJson(PlanRepresentation plan, NodeRepresentation node) {
        List children = (List)node.getChildren().stream().map(plan::getNode).filter(Optional::isPresent).map(Optional::get).map(n -> this.renderJson(plan, (NodeRepresentation)n)).collect(ImmutableList.toImmutableList());
        return new JsonRenderedNode(node.getId().toString(), node.getName(), node.getIdentifier(), node.getDetails(), children, (List)node.getRemoteSources().stream().map(PlanFragmentId::toString).collect(ImmutableList.toImmutableList()));
    }

    public static class JsonPlanFragment {
        @JsonRawValue
        private final String plan;

        @JsonCreator
        public JsonPlanFragment(String plan) {
            this.plan = plan;
        }

        @JsonProperty
        public String getPlan() {
            return this.plan;
        }
    }

    public static class JsonRenderedNode {
        private final String id;
        private final String name;
        private final String identifier;
        private final String details;
        private final List<JsonRenderedNode> children;
        private final List<String> remoteSources;

        @JsonCreator
        public JsonRenderedNode(String id, String name, String identifier, String details, List<JsonRenderedNode> children, List<String> remoteSources) {
            this.id = Objects.requireNonNull(id, "id is null");
            this.name = Objects.requireNonNull(name, "name is null");
            this.identifier = Objects.requireNonNull(identifier, "identifier is null");
            this.details = Objects.requireNonNull(details, "details is null");
            this.children = Objects.requireNonNull(children, "children is null");
            this.remoteSources = Objects.requireNonNull(remoteSources, "id is null");
        }

        @JsonProperty
        public String getId() {
            return this.id;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public String getIdentifier() {
            return this.identifier;
        }

        @JsonProperty
        public String getDetails() {
            return this.details;
        }

        @JsonProperty
        public List<JsonRenderedNode> getChildren() {
            return this.children;
        }

        @JsonProperty
        public List<String> getRemoteSources() {
            return this.remoteSources;
        }
    }
}

