/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.SetOperationNodeUtils;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PushProjectionThroughUnion
implements Rule<ProjectNode> {
    private static final Capture<UnionNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().with(Patterns.source().matching(Patterns.union().capturedAs(CHILD)));

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode parent, Captures captures, Rule.Context context) {
        UnionNode source = (UnionNode)captures.get(CHILD);
        List outputLayout = parent.getOutputVariables();
        ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
        ImmutableList.Builder outputSources = ImmutableList.builder();
        for (int i = 0; i < source.getSources().size(); ++i) {
            Assignments.Builder assignments = Assignments.builder();
            HashMap projectVariableMapping = new HashMap();
            for (Map.Entry entry : parent.getAssignments().entrySet()) {
                RowExpression translatedExpression = RowExpressionVariableInliner.inlineVariables(source.sourceVariableMap(i), (RowExpression)entry.getValue());
                VariableReferenceExpression variable2 = context.getVariableAllocator().newVariable(translatedExpression);
                assignments.put(variable2, translatedExpression);
                projectVariableMapping.put(entry.getKey(), variable2);
            }
            outputSources.add((Object)new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)source.getSources().get(i), assignments.build(), parent.getLocality()));
            outputLayout.forEach(variable -> mappings.put(variable, projectVariableMapping.get(variable)));
        }
        ImmutableListMultimap outputsToInputs = mappings.build();
        return Rule.Result.ofPlanNode((PlanNode)new UnionNode(parent.getId(), (List)outputSources.build(), (List)ImmutableList.copyOf((Collection)outputsToInputs.keySet()), SetOperationNodeUtils.fromListMultimap((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)outputsToInputs)));
    }
}

