/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CanonicalTableScanNode
extends PlanNode {
    private final CanonicalTableHandle table;
    private final Map<VariableReferenceExpression, ColumnHandle> assignments;
    private final List<VariableReferenceExpression> outputVariables;

    @JsonCreator
    public CanonicalTableScanNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") CanonicalTableHandle table, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="assignments") Map<VariableReferenceExpression, ColumnHandle> assignments) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputVariables = Collections.unmodifiableList(Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.assignments = Collections.unmodifiableMap(new HashMap<VariableReferenceExpression, ColumnHandle>(Objects.requireNonNull(assignments, "assignments is null")));
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputVariables), (Object)"assignments does not cover all of outputs");
    }

    public List<PlanNode> getSources() {
        return Collections.emptyList();
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }

    @JsonProperty
    public CanonicalTableHandle getTable() {
        return this.table;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CanonicalTableScanNode that = (CanonicalTableScanNode)((Object)o);
        return Objects.equals(this.table, that.table) && Objects.equals(this.assignments, that.assignments) && Objects.equals(this.outputVariables, that.outputVariables);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.assignments, this.outputVariables);
    }

    public static class CanonicalTableHandle {
        private final ConnectorId connectorId;
        private final ConnectorTableHandle connectorHandle;
        private final Optional<Object> layoutIdentifier;

        public static CanonicalTableHandle getCanonicalTableHandle(TableHandle tableHandle) {
            return new CanonicalTableHandle(tableHandle.getConnectorId(), tableHandle.getConnectorHandle(), tableHandle.getLayout().map(ConnectorTableLayoutHandle::getIdentifier));
        }

        @JsonCreator
        public CanonicalTableHandle(@JsonProperty(value="coonectorId") ConnectorId connectorId, @JsonProperty(value="connectorHandle") ConnectorTableHandle connectorHandle, @JsonProperty(value="layoutIdentifier") Optional<Object> layoutIdentifier) {
            this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
            this.connectorHandle = Objects.requireNonNull(connectorHandle, "connectorHandle is null");
            this.layoutIdentifier = Objects.requireNonNull(layoutIdentifier, "layoutIdentifier is null");
        }

        @JsonProperty
        public ConnectorId getConnectorId() {
            return this.connectorId;
        }

        @JsonProperty
        public ConnectorTableHandle getConnectorHandle() {
            return this.connectorHandle;
        }

        @JsonProperty
        public Optional<Object> getLayoutIdentifier() {
            return this.layoutIdentifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CanonicalTableHandle that = (CanonicalTableHandle)o;
            return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.connectorHandle, that.connectorHandle) && Objects.equals(this.layoutIdentifier, that.layoutIdentifier);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.connectorHandle, this.layoutIdentifier);
        }
    }
}

