/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import java.util.Set;

public final class ConstantExpressionVerifier {
    private ConstantExpressionVerifier() {
    }

    public static void verifyExpressionIsConstant(Set<NodeRef<Expression>> columnReferences, Expression expression) {
        new ConstantExpressionVerifierVisitor(columnReferences, expression).process((Node)expression, null);
    }

    private static class ConstantExpressionVerifierVisitor
    extends DefaultTraversalVisitor<Void, Void> {
        private final Set<NodeRef<Expression>> columnReferences;
        private final Expression expression;

        public ConstantExpressionVerifierVisitor(Set<NodeRef<Expression>> columnReferences, Expression expression) {
            this.columnReferences = columnReferences;
            this.expression = expression;
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, Void context) {
            if (this.columnReferences.contains(NodeRef.of((Node)node))) {
                throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)this.expression, "Constant expression cannot contain column references", new Object[0]);
            }
            this.process((Node)node.getBase(), context);
            return null;
        }

        protected Void visitIdentifier(Identifier node, Void context) {
            throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)this.expression, "Constant expression cannot contain column references", new Object[0]);
        }

        protected Void visitFieldReference(FieldReference node, Void context) {
            throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)this.expression, "Constant expression cannot contain column references", new Object[0]);
        }
    }
}

