/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.thrift;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.presto.server.codec.Codec;
import com.google.common.base.Verify;
import java.util.Objects;

public class ThriftCodecWrapper<T>
implements Codec<T> {
    private final ThriftCodec<T> thriftCodec;

    public ThriftCodecWrapper(ThriftCodec<T> thriftCodec) {
        this.thriftCodec = Objects.requireNonNull(thriftCodec, "thriftCodec is null");
    }

    public static <T> ThriftCodecWrapper<T> wrapThriftCodec(ThriftCodec<T> codec) {
        return new ThriftCodecWrapper<T>(codec);
    }

    public static <T> ThriftCodec<T> unwrapThriftCodec(Codec<T> codec) {
        Verify.verify((boolean)(codec instanceof ThriftCodecWrapper));
        return ((ThriftCodecWrapper)codec).thriftCodec;
    }

    @Override
    public byte[] toBytes(T instance) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public T fromBytes(byte[] bytes) {
        throw new UnsupportedOperationException("Operation not supported");
    }
}

