/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.smile;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.server.codec.Codec;
import com.google.common.base.Verify;
import java.util.Objects;

public class JsonCodecWrapper<T>
implements Codec<T> {
    private final JsonCodec<T> jsonCodec;

    private JsonCodecWrapper(JsonCodec<T> jsonCodec) {
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
    }

    public static <T> JsonCodecWrapper<T> wrapJsonCodec(JsonCodec<T> codec) {
        return new JsonCodecWrapper<T>(codec);
    }

    public static <T> JsonCodec<T> unwrapJsonCodec(Codec<T> codec) {
        Verify.verify((boolean)(codec instanceof JsonCodecWrapper));
        return ((JsonCodecWrapper)codec).jsonCodec;
    }

    @Override
    public byte[] toBytes(T instance) {
        return this.jsonCodec.toJsonBytes(instance);
    }

    @Override
    public T fromBytes(byte[] bytes) {
        return (T)this.jsonCodec.fromJson(bytes);
    }
}

