/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.log.Logger;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.Session;
import com.facebook.presto.server.SessionPropertyConfigurationManagerContextInstance;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.SessionPropertyConfigurationManagerContext;
import com.facebook.presto.spi.session.SessionConfigurationContext;
import com.facebook.presto.spi.session.SessionPropertyConfigurationManager;
import com.facebook.presto.spi.session.SessionPropertyConfigurationManagerFactory;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;

public class SessionPropertyDefaults {
    private static final Logger log = Logger.get(SessionPropertyDefaults.class);
    private static final File SESSION_PROPERTY_CONFIGURATION = new File("etc/session-property-config.properties");
    private static final String SESSION_PROPERTY_MANAGER_NAME = "session-property-config.configuration-manager";
    private final SessionPropertyConfigurationManagerContext configurationManagerContext;
    private final Map<String, SessionPropertyConfigurationManagerFactory> factories = new ConcurrentHashMap<String, SessionPropertyConfigurationManagerFactory>();
    private final AtomicReference<SessionPropertyConfigurationManager> delegate = new AtomicReference();

    @Inject
    public SessionPropertyDefaults(NodeInfo nodeInfo) {
        this.configurationManagerContext = new SessionPropertyConfigurationManagerContextInstance(nodeInfo.getEnvironment());
    }

    public void addConfigurationManagerFactory(SessionPropertyConfigurationManagerFactory sessionConfigFactory) {
        if (this.factories.putIfAbsent(sessionConfigFactory.getName(), sessionConfigFactory) != null) {
            throw new IllegalArgumentException(String.format("Session property configuration manager '%s' is already registered", sessionConfigFactory.getName()));
        }
    }

    public void loadConfigurationManager() throws IOException {
        if (!SESSION_PROPERTY_CONFIGURATION.exists()) {
            return;
        }
        Map<String, String> properties = PropertiesUtil.loadProperties(SESSION_PROPERTY_CONFIGURATION);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)properties.get(SESSION_PROPERTY_MANAGER_NAME)) ? 1 : 0) != 0, (String)"Session property configuration %s does not contain %s", (Object)SESSION_PROPERTY_CONFIGURATION, (Object)SESSION_PROPERTY_MANAGER_NAME);
        this.loadConfigurationManager(properties);
    }

    public void loadConfigurationManager(Map<String, String> properties) {
        String sessionPropertyManagerName = (properties = new HashMap<String, String>(properties)).remove(SESSION_PROPERTY_MANAGER_NAME);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sessionPropertyManagerName) ? 1 : 0) != 0, (String)"%s property must be present", (Object)SESSION_PROPERTY_MANAGER_NAME);
        this.setConfigurationManager(sessionPropertyManagerName, properties);
    }

    @VisibleForTesting
    public void setConfigurationManager(String configManagerName, Map<String, String> properties) {
        log.info("-- Loading session property configuration manager --");
        SessionPropertyConfigurationManagerFactory factory = this.factories.get(configManagerName);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Session property configuration manager '%s' is not registered", (Object)configManagerName);
        SessionPropertyConfigurationManager manager = factory.create(properties, this.configurationManagerContext);
        Preconditions.checkState((boolean)this.delegate.compareAndSet(null, manager), (Object)"sessionPropertyConfigurationManager is already set");
        log.info("-- Loaded session property configuration manager %s --", new Object[]{configManagerName});
    }

    public Session newSessionWithDefaultProperties(Session session, Optional<String> queryType, Optional<ResourceGroupId> resourceGroupId) {
        SessionPropertyConfigurationManager configurationManager = this.delegate.get();
        if (configurationManager == null) {
            return session;
        }
        SessionConfigurationContext context = new SessionConfigurationContext(session.getIdentity().getUser(), session.getSource(), session.getClientTags(), queryType, resourceGroupId);
        Map systemPropertyOverrides = configurationManager.getSystemSessionProperties(context);
        Map catalogPropertyOverrides = configurationManager.getCatalogSessionProperties(context);
        return session.withDefaultProperties(systemPropertyOverrides, catalogPropertyOverrides);
    }
}

