/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.connector.system.KillQueryProcedure;
import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/v1/query")
@RolesAllowed(value={"user", "admin"})
public class QueryResource {
    private final DispatchManager dispatchManager;
    private final QueryManager queryManager;

    @Inject
    public QueryResource(DispatchManager dispatchManager, QueryManager queryManager) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
    }

    @GET
    public List<BasicQueryInfo> getAllQueryInfo(@QueryParam(value="state") String stateFilter) {
        QueryState expectedState = stateFilter == null ? null : QueryState.valueOf(stateFilter.toUpperCase(Locale.ENGLISH));
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (BasicQueryInfo queryInfo : this.dispatchManager.getQueries()) {
            if (stateFilter != null && queryInfo.getState() != expectedState) continue;
            builder.add((Object)queryInfo);
        }
        return builder.build();
    }

    @GET
    @Path(value="{queryId}")
    public Response getQueryInfo(@PathParam(value="queryId") QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        try {
            QueryInfo queryInfo = this.queryManager.getFullQueryInfo(queryId);
            return Response.ok((Object)queryInfo).build();
        }
        catch (NoSuchElementException e) {
            try {
                BasicQueryInfo basicQueryInfo = this.dispatchManager.getQueryInfo(queryId);
                return Response.ok((Object)basicQueryInfo).build();
            }
            catch (NoSuchElementException ex) {
                return Response.status((Response.Status)Response.Status.GONE).build();
            }
        }
    }

    @DELETE
    @Path(value="{queryId}")
    public void cancelQuery(@PathParam(value="queryId") QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        this.dispatchManager.cancelQuery(queryId);
    }

    @PUT
    @Path(value="{queryId}/killed")
    public Response killQuery(@PathParam(value="queryId") QueryId queryId, String message) {
        return this.failQuery(queryId, KillQueryProcedure.createKillQueryException(message));
    }

    @PUT
    @Path(value="{queryId}/preempted")
    public Response preemptQuery(@PathParam(value="queryId") QueryId queryId, String message) {
        return this.failQuery(queryId, KillQueryProcedure.createPreemptQueryException(message));
    }

    private Response failQuery(QueryId queryId, PrestoException queryException) {
        Objects.requireNonNull(queryId, "queryId is null");
        try {
            BasicQueryInfo state = this.dispatchManager.getQueryInfo(queryId);
            if (state.getState().isDone()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            this.dispatchManager.failQuery(queryId, queryException);
            if (!queryException.getErrorCode().equals((Object)this.dispatchManager.getQueryInfo(queryId).getErrorCode())) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }

    @DELETE
    @Path(value="stage/{stageId}")
    public void cancelStage(@PathParam(value="stageId") StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        this.queryManager.cancelStage(stageId);
    }
}

