/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.spi.function.ValueWindowFunction;
import com.facebook.presto.spi.function.WindowFunctionSignature;
import com.google.common.collect.Iterables;
import java.util.List;

@WindowFunctionSignature(name="first_value", typeVariable="T", returnType="T", argumentTypes={"T"})
public class FirstValueFunction
extends ValueWindowFunction {
    private final int argumentChannel;

    public FirstValueFunction(List<Integer> argumentChannels) {
        this.argumentChannel = (Integer)Iterables.getOnlyElement(argumentChannels);
    }

    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        int valuePosition;
        if (frameStart < 0) {
            output.appendNull();
            return;
        }
        if (this.ignoreNulls) {
            for (valuePosition = frameStart; valuePosition >= 0 && valuePosition <= frameEnd && this.windowIndex.isNull(this.argumentChannel, valuePosition); ++valuePosition) {
            }
            if (valuePosition > frameEnd) {
                output.appendNull();
                return;
            }
        }
        this.windowIndex.appendTo(this.argumentChannel, valuePosition, output);
    }
}

