/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.SqlInvokedScalarFunction;
import com.facebook.presto.spi.function.SqlParameter;
import com.facebook.presto.spi.function.SqlType;

public class ArrayArithmeticFunctions {
    private ArrayArithmeticFunctions() {
    }

    @SqlInvokedScalarFunction(value="array_sum", deterministic=true, calledOnNullInput=false)
    @Description(value="Returns the sum of all array elements, or 0 if the array is empty. Ignores null elements.")
    @SqlParameter(name="input", type="array<bigint>")
    @SqlType(value="bigint")
    public static String arraySumBigint() {
        return "RETURN reduce(input, BIGINT '0', (s, x) -> s + coalesce(x, BIGINT '0'), s -> s)";
    }

    @SqlInvokedScalarFunction(value="array_sum", deterministic=true, calledOnNullInput=false)
    @Description(value="Returns the sum of all array elements, or 0 if the array is empty. Ignores null elements.")
    @SqlParameter(name="input", type="array<double>")
    @SqlType(value="double")
    public static String arraySumDouble() {
        return "RETURN reduce(input, DOUBLE '0', (s, x) -> s + coalesce(x, DOUBLE '0'), s -> s)";
    }

    @SqlInvokedScalarFunction(value="array_average", deterministic=true, calledOnNullInput=false)
    @Description(value="Returns the average of all array elements, or null if the array is empty. Ignores null elements.")
    @SqlParameter(name="input", type="array<double>")
    @SqlType(value="double")
    public static String arrayAverage() {
        return "RETURN reduce(input, (double '0.0', 0), (s, x) -> IF(x IS NOT NULL, (s[1] + x, s[2] + 1), s), s -> if(s[2] = 0, cast(null as double), s[1] / cast(s[2] as double)))";
    }
}

