/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;

public final class ZipFunction
extends SqlScalarFunction {
    public static final int MIN_ARITY = 2;
    public static final int MAX_ARITY = 5;
    public static final ZipFunction[] ZIP_FUNCTIONS;
    private static final MethodHandle METHOD_HANDLE;
    private final List<String> typeParameters;

    private ZipFunction(int arity) {
        this((List)IntStream.rangeClosed(1, arity).mapToObj(s -> "T" + s).collect(ImmutableList.toImmutableList()));
    }

    private ZipFunction(List<String> typeParameters) {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"zip"), FunctionKind.SCALAR, (List)typeParameters.stream().map(Signature::typeVariable).collect(ImmutableList.toImmutableList()), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)("array(row(" + String.join((CharSequence)",", typeParameters) + "))")), (List)typeParameters.stream().map(name -> "array(" + name + ")").map(TypeSignature::parseTypeSignature).collect(ImmutableList.toImmutableList()), false));
        this.typeParameters = typeParameters;
    }

    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    public boolean isDeterministic() {
        return true;
    }

    public String getDescription() {
        return "Merges the given arrays, element-wise, into a single array of rows.";
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        List types = (List)this.typeParameters.stream().map(boundVariables::getTypeVariable).collect(ImmutableList.toImmutableList());
        List<BuiltInScalarFunctionImplementation.ArgumentProperty> argumentProperties = Collections.nCopies(types.size(), BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL));
        List<Class<?>> javaArgumentTypes = Collections.nCopies(types.size(), Block.class);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(types).asVarargsCollector(Block[].class).asType(MethodType.methodType(Block.class, javaArgumentTypes));
        return new BuiltInScalarFunctionImplementation(false, argumentProperties, methodHandle);
    }

    @UsedByGeneratedCode
    public static Block zip(List<Type> types, Block ... arrays) {
        int biggestCardinality = 0;
        for (Block array : arrays) {
            biggestCardinality = Math.max(biggestCardinality, array.getPositionCount());
        }
        RowType rowType = RowType.anonymous(types);
        BlockBuilder outputBuilder = rowType.createBlockBuilder(null, biggestCardinality);
        for (int outputPosition = 0; outputPosition < biggestCardinality; ++outputPosition) {
            BlockBuilder rowBuilder = outputBuilder.beginBlockEntry();
            for (int fieldIndex = 0; fieldIndex < arrays.length; ++fieldIndex) {
                if (arrays[fieldIndex].getPositionCount() <= outputPosition) {
                    rowBuilder.appendNull();
                    continue;
                }
                types.get(fieldIndex).appendTo(arrays[fieldIndex], outputPosition, rowBuilder);
            }
            outputBuilder.closeEntry();
        }
        return outputBuilder.build();
    }

    static {
        METHOD_HANDLE = Reflection.methodHandle(ZipFunction.class, "zip", List.class, Block[].class);
        ZIP_FUNCTIONS = new ZipFunction[4];
        for (int arity = 2; arity <= 5; ++arity) {
            ZipFunction.ZIP_FUNCTIONS[arity - 2] = new ZipFunction(arity);
        }
    }
}

