/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.OptimizedTypedSet;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;

@ScalarFunction(value="array_intersect")
@Description(value="Intersects elements of the two given arrays")
public final class ArrayIntersectFunction {
    private ArrayIntersectFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block intersect(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int rightPositionCount;
        if (leftArray.getPositionCount() < rightArray.getPositionCount()) {
            Block tempArray = leftArray;
            leftArray = rightArray;
            rightArray = tempArray;
        }
        if ((rightPositionCount = rightArray.getPositionCount()) == 0) {
            return rightArray;
        }
        OptimizedTypedSet typedSet = new OptimizedTypedSet(type, rightPositionCount);
        typedSet.union(rightArray);
        typedSet.intersect(leftArray);
        return typedSet.getBlock();
    }
}

